package cn.com.duiba.live.normal.service.api.dto.sign;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播增员签到用户签到记录
 * @author kjj mybatis generator 
 * @date 2021-03-28
 */
@Data
public class LiveIncrStaffSignRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16168626568297756L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 签到配置Id,tb_live_user_sign_in_config主键id
     */
    private Long signConfigId;

    /**
     * 直播userId
     */
    private Long liveUserId;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户手机号
     */
    private String phoneNum;

    /**
     * 用户类型：是否参与该场直播 1：是、2：不是
     * @see cn.com.duiba.live.normal.service.api.enums.sign.SignUserTypeEnum
     */
    private Integer userType;

    /**
     * 问券Id
     */
    private Long surveyId;

    /**
     * 直播邀请代理人ID
     */
    private Long agentId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}