package cn.com.duiba.live.normal.service.api.enums.sign;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author linjianhui
 * @description 签到用户类型是否参与直播
 * @date 2021/3/28 22:02
 */
@Getter
@AllArgsConstructor
public enum SignUserTypeEnum {

    /**
     * 是否参与直播 1：是、2：不是
     */
    LIVE_USER(1, "参与该场直播"),
    UN_LIVE_USER(2, "未参与该场直播"),
    ;

    /**
     * 类型
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;
}
