package cn.com.duiba.live.normal.service.api.remoteservice.sign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.sign.LiveIncrStaffSignRecordDto;

/**
 * @author linjianhui
 * @description 增员签到打卡记录
 * @date 2021/3/28 22:40
 */
@AdvancedFeignClient
public interface RemoteLiveIncrStaffSignRecordService {

    /**
     * 新增签到记录
     * @param dto 签到记录
     * @return 主键id
     */
    Long insert(LiveIncrStaffSignRecordDto dto);

    /**
     * 编辑签到记录
     * @param dto 签到记录
     * @return 变更条数
     */
    Integer update(LiveIncrStaffSignRecordDto dto);

    /**
     * 通过签到配置id和用户id查询
     * @param signConfigId 配置id
     * @param liveUserId 直播用户id
     * @return
     */
    LiveIncrStaffSignRecordDto findByConfigIdAndUserId(Long signConfigId, Long liveUserId);
}
