package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 17:54
 * 客户信息排序枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustSortTypeEnum {

    ASSIGN_TIME("last_assign_time desc", "根据最近分配时间降序排序"),
    CUST_STAR_VALUE_ASSIGN_TIME("cust star desc,cust_value desc,last_assign_time desc", "根据客户价值降序排列，相同则最近指派时间降序排序");

    /**
     * 排序字段
     */
    private final String sortField;

    /**
     * 描述
     */
    private final String desc;
}
