package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import cn.com.duiba.live.normal.service.api.util.NumberUtil;
import com.google.common.collect.Sets;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 17:23
 */
@Getter
@AllArgsConstructor
public enum OtoCustValueEnum {

    X("X", 101,  "拨打未接通次数 >= 5"),
    N("N", 102,"拨打次数5次内未接通"),
    ZERO("0", 200, "销售手动输入"),
    ONE("1", 201, "销售手动输入"),
    TWO("2", 202, "销售手动输入"),
    THREE("3", 203, "销售手动输入"),
    THREE_A("3-A", 301, "递交了计划书，近期有机会成交"),
    THREE_B("3-B", 302, "递交了计划书，近期无法成交"),
    THREE_C("3-C", 303, "递交了计划书,拒绝");

    /**
     * 展示价值
     */
    private final String showValue;

    /**
     * 价值
     */
    private final Integer realValue;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 低级价值
     */
    public static final Set<Integer> LOWER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet(X.getRealValue(), N.getRealValue(), ZERO.getRealValue()));

    /**
     * 手动输入数字价值
     */
    public static final Set<Integer> NUMBER_VALUE_LIST = Collections.unmodifiableSet(Sets.newHashSet(ZERO.getRealValue(), ONE.getRealValue(), TWO.getRealValue(), THREE.getRealValue()));

    /**
     * 可以提交计划书/成交的客户价值
     */
    public static final Set<Integer> PLAN_OR_DEL_LIST = Collections.unmodifiableSet(Sets.newHashSet(THREE_A.getRealValue(), THREE_B.getRealValue(), THREE_C.getRealValue()));

    /**
     * 全部价值
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustValueEnum::getRealValue, OtoCustValueEnum::getShowValue)));

    public static String getShowValue(Integer realValue){
        if (NumberUtil.isNullOrLteZero(realValue)) {
            return null;
        }
        return ALL_MAP.get(realValue);
    }

    /**
     * 是否可以替换为新的value
     * @param oldValue 老的value
     * @param newValue 新的value
     * @return 是否可以替换
     */
    public static boolean canReplace(Integer oldValue, Integer newValue){
        if (newValue == null) {
            return false;
        }
        if (oldValue == null && NUMBER_VALUE_LIST.contains(newValue)) {
            return true;
        }

        if (newValue.equals(oldValue)) {
            return true;
        }
        // X/N/0 可以替换为 X/N/0/1/2/3
        if (LOWER_VALUE_LIST.contains(oldValue)){
            return LOWER_VALUE_LIST.contains(newValue) || NUMBER_VALUE_LIST.contains(newValue) ;
        }

        // 1-3只允许增大
        if (NUMBER_VALUE_LIST.contains(oldValue) ) {
            return NUMBER_VALUE_LIST.contains(newValue) && newValue > oldValue;
        }

        return false;
    }
}
