package cn.com.duiba.live.normal.service.api.remoteservice.oto;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.OtoSellerDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * OTO-销售信息
 *
 * @author ZhangJun
 * @date 2022/1/7 5:59 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerService {

    /**
     * 根据销售id查询销售信息
     *
     * @param id 销售id
     * @return 销售信息
     */
    OtoSellerDto findById(Long id);

    /**
     * 根据手机号查询销售信息
     *
     * @param phoneNumber 销售手机号
     * @return 销售信息
     */
    OtoSellerDto findByPhone(String phoneNumber);

    /**
     * 查询销售名称
     *
     * @param ids 销售id
     * @return key销售id value销售名称
     */
    Map<Long, String> selectNicknameMap(List<Long> ids);

    /**
     * 新增销售
     *
     * @param dto 销售信息
     * @return 新增结果
     */
    boolean save(OtoSellerDto dto);

    /**
     * 编辑销售
     *
     * @param dto 销售信息
     * @return 编辑结果
     */
    boolean update(OtoSellerDto dto);

    /**
     * 启用/禁用销售账号
     *
     * @param id           销售id
     * @param sellerStatus 销售账号状态
     *                     {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerStatusEnum}
     * @return 启用/禁用结果
     */
    boolean switchSellerStatus(Long id, Integer sellerStatus);

    /**
     * 启用/禁用销售电话权限
     *
     * @param id             销售id
     * @param callPermission 销售拨打电话权限
     *                       {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerCallPermissionEnum}
     * @return 启用/禁用结果
     */
    boolean switchCallPermission(Long id, Integer callPermission);

    /**
     * 更新最后登录时间
     *
     * @param id            销售id
     * @param lastLoginTime 最后登录时间
     * @return 更新结果
     */
    boolean updateLastLoginTime(Long id, Date lastLoginTime);

}
