package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustomerDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-10 13:44
 * 客户 rpc service
 */
@AdvancedFeignClient
public interface RemoteOtoCustService {

    /**
     * 根据客户id查询客户信息
     * @param custId 客户id
     * @return 客户信息
     */
    OtoCustomerDto findById(Long custId);

    /**
     * 根据客户id批量查询客户信息
     * @param custIds 客户id
     * @return 客户信息
     */
    List<OtoCustomerDto> listByIds(List<Long> custIds);

    /**
     * 根据客户id批量查询客户信息（过滤掉当前代理人未跟进的）
     * @param custIds 客户id
     * @param otoSid 销售id
     * @return 客户信息
     */
    List<OtoCustomerDto> listByIdsAndSid(List<Long> custIds, Long otoSid);
}
