package cn.com.duiba.live.normal.service.api.dto.oto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * OTO-销售信息
 *
 * @author ZhangJun
 * @date 2022/1/7 5:16 下午
 */
@Data
public class OtoSellerDto implements Serializable {

    private static final long serialVersionUID = -6283587838740023380L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售手机号
     */
    private String phoneNumber;

    /**
     * 销售姓名
     */
    private String sellerName;

    /**
     * 销售头像url
     */
    private String sellerAvatar;

    /**
     * 销售账号状态,0-禁用,1-启用
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerStatusEnum}
     */
    private Integer sellerStatus;

    /**
     * 呼叫权限,0-禁用,1-启用
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerCallPermissionEnum}
     */
    private Integer callPermission;

    /**
     * 角色类型,1-普通销售,2-销售管理员
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.OtoSellerRoleTypeEnum}
     */
    private Integer roleType;

    /**
     * 销售所在地区
     */
    private String sellerArea;

    /**
     * 最后登录时间
     */
    private Date lastLoginTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}
