package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * OTO-标签状态枚举
 *
 * @author ZhangJun
 * @date 2022/1/7 11:15 上午
 */
@Getter
@AllArgsConstructor
public enum OtoTagStatusEnum {

    /**
     * 标签处于关闭状态，不可见，不可打标签
     */
    CLOSE(0, "关闭"),

    /**
     * 标签开启
     */
    OPEN(1, "开启"),
    ;

    private Integer tagStatus;
    private String desc;

}
