/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import cn.com.duiba.live.normal.service.api.util.NumberUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;

public enum OtoCustPoolEnum {
    WAIT_POOL(1, "\u9884\u5907\u6c60"),
    FRESH_POOL(2, "\u6295\u653e\u6c60"),
    FOLLOW_POOL(3, "\u8ddf\u8fdb\u6c60"),
    RECYCLE_POOL(4, "\u56de\u6536\u6c60"),
    GARBAGE_POOL(5, "\u5783\u573e\u6c60");

    private Integer poolType;
    private String desc;
    private static final List<OtoCustPoolEnum> CLAIM_POOLS;

    public static List<Integer> claimPools() {
        return CLAIM_POOLS.stream().map(OtoCustPoolEnum::getPoolType).collect(Collectors.toList());
    }

    public static boolean canClaim(Integer poolType) {
        if (NumberUtil.isNullOrLteZero(poolType)) {
            return false;
        }
        return OtoCustPoolEnum.claimPools().contains(poolType);
    }

    public Integer getPoolType() {
        return this.poolType;
    }

    public String getDesc() {
        return this.desc;
    }

    private OtoCustPoolEnum(Integer poolType, String desc) {
        this.poolType = poolType;
        this.desc = desc;
    }

    static {
        CLAIM_POOLS = Lists.newArrayList((Object[])new OtoCustPoolEnum[]{FRESH_POOL, RECYCLE_POOL});
    }
}

