package cn.com.duiba.live.normal.service.api.dto.activate;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播代理人导入任务表
 * @author kjj mybatis generator 
 * @date 2020-08-28
 */
@Data
public class LiveAgentImportTaskDto implements Serializable {
     
    private static final long serialVersionUID = 15985983781672862L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 导入总数
     */
    private Integer totalCount;

    /**
     * 导入失败数量
     */
    private Integer failureCount;

    /**
     * 导入成功数量
     */
    private Integer successCount;

    /**
     * 任务状态 0:初始化 1:导入中 2:导入失败(系统报错) 3:导入完成
     * @see cn.com.duiba.kjy.livecenter.api.enums.advice.AgentImportTaskEnum
     */
    private Integer taskStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}