package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 20:08
 */
@Data
public class OtoCustomerPageDto implements Serializable {

    private static final long serialVersionUID = -6352158074729359750L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 跟进客户权重
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 上次跟进时间
     */
    private Date lastFollowTime;

    /**
     * 跟进状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowStatusEnum
     */
    private Integer followStatus;

    /**
     * 跟进次数 = 打电话次数 + 面访次数 + 参观次数
     */
    private Integer followTimes;

    /**
     * 上次分配时间
     */
    private Date lastAssignTime;

    /**
     * 分配类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustAssignTypeEnum
     */
    private Integer assignType;

    /**
     * 标签
     */
    private String tags;

    /**
     * 是否为星标客户
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer custStar;
}
