package cn.com.duiba.live.normal.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.clue.LiveClueSpeakDto;
import cn.com.duiba.live.normal.service.api.param.clue.LiveClueSpeakParam4Task;
import cn.com.duiba.live.normal.service.api.param.clue.LiveClueSpeakSearchParam;

import java.util.List;

/**
 * Created by dugq on 2020-04-03.
 */
@AdvancedFeignClient
public interface RemoteLiveClueSpeakApiService {
    /**
     * 批量查询弹幕记录
     * @param param 搜索条件
     * @return 弹幕记录
     */
    List<LiveClueSpeakDto> selectList(LiveClueSpeakSearchParam param);

    /**
     * 弹幕数量
     * @param param 搜索条件
     * @return 弹幕数量
     */
    Long selectCount(LiveClueSpeakSearchParam param);

    /**
     * 新增单条弹幕
     * @param dto 弹幕
     * @return 是否添加成功
     */
    int insert(LiveClueSpeakDto dto);

    /**
     * 批量新增弹幕记录
     * @param list 弹幕记录
     * @return 新增数量
     */
    int batchInsert(List<LiveClueSpeakDto> list);

    /**
     * 根据条件查询 不分页
     * @param param
     * @return
     */
    List<LiveClueSpeakDto> findByCondition4Task(LiveClueSpeakParam4Task param);

    /**
     * !!!!!!!数据修复专用 其它地方慎用!!!!!
     * 更新答题数据
     * @param liveId 直播间id
     * @param visitorIds 访客id列表
     * @param agentId 代理人id
     * @return 影响行数
     */
    int updateAgentId4DataFix(Long liveId, List<Long> visitorIds, Long agentId);
}
