package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.CustCallRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-16 10:00
 */
@AdvancedFeignClient
public interface RemoteCustCallRecordService {

    /**
     * 根据日志id获取通话记录
     * @param callLogId 日志id
     * @return 通话记录
     */
    CustCallRecordDto findByCallLogId(Long callLogId);

    /**
     * 保存通话记录
     *
     * @param custCallRecordDto 通话记录
     * @return 保存结果
     */
    boolean save(CustCallRecordDto custCallRecordDto);

    /**
     * 筛选通话记录小于指定时间的客户
     *
     * @param sellerId 销售id
     * @param custIds  客户id
     * @param endDate  时间
     * @return 客户id
     */
    List<Long> searchLtCallTime(Long sellerId, List<Long> custIds, Date endDate);
}
