package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
* 客户所在资源池枚举
*
* 资源池流转过程：
*
*                                                                           <------销售认领---------｜
*                                                                           ｜                     ｜
* 客户填写表单 -----> 「预备池」 ---定时任务待认领--> 「投放池」 ---销售认领--> 「跟进池」---系统回收----> 「回收池」
*                                                                                    ｜
*                                                                                    ｜
*                                                                                    -------> 「垃圾池」
* @author ZhangJun
* @date 2022/2/14 16:27
*/
@Getter
@AllArgsConstructor
public enum OtoCustPoolEnum {

    WAIT_POOL(1, "预备池"),
    FRESH_POOL(2, "投放池"),
    FOLLOW_POOL(3, "跟进池"),
    RECYCLE_POOL(4, "回收池"),
    GARBAGE_POOL(5, "垃圾池")
    ;

    /**
     * 客户资源池类型
     */
    private Integer poolType;

    /**
     * 资源池描述
     */
    private String desc;

}
