package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LiveAgentQrCodeDto;
import cn.com.duiba.live.normal.service.api.param.live.LiveAgentQrCodeSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 直播代理人小程序二维码服务
 * @author 吴文哲
 * @date 2020-04-11 16:25
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentQrCodeApiService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播代理人小程序二维码集合
     */
    List<LiveAgentQrCodeDto> selectList(LiveAgentQrCodeSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播代理人小程序二维码
     */
    LiveAgentQrCodeDto selectById(Long id);

    /**
     * 根据直播间id  公司id  代理人id 查询
     * @param liveId
     * @param companyId
     * @param agentId
     * @return
     */
    LiveAgentQrCodeDto getByLiveIdCompanyIdAgentId(Long liveId, Long companyId, Long agentId);

    /**
     * 新增/修改
     * @param dto
     * @return
     */
    Long addOrUpdate(LiveAgentQrCodeDto dto);

    /**
     * 批量保存
     * @param agentQrCodeDtos
     * @return
     */
    Integer batchSave(List<LiveAgentQrCodeDto> agentQrCodeDtos);

    /**
     * 获取微信小程序二维码地址
     * @param liveId
     * @param companyId
     * @param agentId
     * @return
     */
    String findQrCOdeUrl(Long liveId, Long companyId, Long agentId);

    /**
     * 清除代理人小程序码
     * @param id 主键
     */
    void clearQrCodeUrl(Long id);

    /**
     * 批量保存或更新，insert or update实现
     * @param list
     * @return 执行结果，注意结果不一定与条数对应
     */
    Integer batchInsertOrUpdate(List<LiveAgentQrCodeDto> list);

    /**
     * 批量查询代理人二维码
     * @param liveId 直播id
     * @param companyId 公司id
     * @param agentIds 代理人id集合
     * @return key：代理人id value：代理人二维码
     */
    Map<Long, String> findByLiveAndAgentIds(Long liveId, Long companyId, List<Long> agentIds);

}
