package cn.com.duiba.live.normal.service.api.remoteservice.liveagentcustomer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.liveAgentCustomer.LiveAgentCustomerDto;

import java.util.List;

/**
 * 直播代理人客户服务
 * @Author chentiecheng
 * @Date 2021/2/2 1:45 下午
 */
@AdvancedFeignClient
public interface RemoteLiveAgentCustomerService {
    /**
     * 根据代理人id和直播用户id查询客户
     * @param agentId
     * @param liveUserIds
     * @return
     */
    List<LiveAgentCustomerDto> selectListByAgentIdAndLiveUserIds(Long agentId,List<Long> liveUserIds);

    /**
     * 新增/更新客户
     * @param dto
     * @return
     */
    Boolean insertOrUpdateCustomer(LiveAgentCustomerDto dto);


    /**
     * 根据代理人id和客户id查询
     * @return 直播代理人客户
     */
    LiveAgentCustomerDto selectByAgentIdAndUserId(Long agentId, Long liveUserId);


    /**
     * 批量新增/更新备注名
     * @param list
     * @return
     */
    int batchInsertOrUpdateName(List<LiveAgentCustomerDto> list);


}
