package cn.com.duiba.live.normal.service.api.remoteservice.black;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.black.LivePreBlacklistDto;
import cn.com.duiba.live.normal.service.api.param.black.LivePreBlacklistSearchParam;
import java.util.List;

/**
 * 直播预设黑名单
 * @author ouyang
 * @date 2022/7/25 10:04 AM
 */
@AdvancedFeignClient
public interface RemoteLivePreBlackListApiService {


    /**
     * 查询在预设黑名单里的手机号
     * @param phoneNums 需要设置的用户手机集合
     * @return 在预设黑名单里的手机集合
     */
    List<String> findByPhoneNums(List<String> phoneNums);

    /**
     * 批量新增
     * @param list 直播预设黑名单
     * @return 执行结果
     */
    int batchInsert(List<LivePreBlacklistDto> list);

    /**
     * 批量物理删除
     * @param phoneNums 用户手机集合
     * @return 执行结果
     */
    int batchDelete(List<String> phoneNums);

    /**
     * 批量物理删除(id)
     * @param ids ids
     * @return 执行结果
     */
    int batchDeleteById(List<Long> ids);


    /**
     * 根据主键查询
     * @param id 主键id
     * @return 直播预设黑名单对象
     */
    LivePreBlacklistDto findById(Long id);

    /**
     * 根据手机号查询
     * @param phoneNum 用户手机
     * @return 直播预设黑名单信息
     */
    LivePreBlacklistDto findByPhoneNum(String phoneNum);

    /**
     * 根据条件查询列表
     * @param param 查询条件
     * @return 直播黑名单列表
     */
    List<LivePreBlacklistDto> findByCondition(LivePreBlacklistSearchParam param);

    /**
     * 根据条件统计总数
     * @param param 查询条件
     * @return 总数
     */
    long countByCondition(LivePreBlacklistSearchParam param);
}
