package cn.com.duiba.live.ws.register.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 直播间左侧评论区上方公共推送，每秒所有类型最多推送10个
 * @author lizhi
 * @date 2020/11/3 1:45 下午
 */
@AdvancedFeignClient
public interface RemotePushAllInLeftAreaService {

    /**
     * 往队列中添加需要推送给全部用户的推送
     * @param liveId 直播ID
     * @param msgType 推送的消息类型
     * @see cn.com.duiba.live.ws.register.api.enums.WsMsgTypeEnum
     */
    <T> void addPushAll(Long liveId, int msgType, List<T> pushList);
}
