package cn.com.duiba.live.ws.register.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * websocket定时推送 【通用队列】操作。 包含用户类型【所有用户】【指定用户】 包含类型【插入】【查询】
 * !important 当通用队列达到限流瓶颈时，限流策略（动态可配置,默认不丢弃）可能选择丢弃。所以【重要推送（不可丢弃）】请选择其他方法。
 * @author dugq
 * @date 2020-07-01
 */
@AdvancedFeignClient
public interface RemoteCommonPushService {
    /**
     * 往队列中添加需要推送给全部用户的推送
     * @param liveId 直播ID
     * @param messageList 推送内容。直接传入对象列表
     */
    <T> void addCommonPushAll(Long liveId, int msgType, List<T> messageList);

    /**
     * 往队列中添加需要推送给指定用户的推送
     * @param liveId 直播ID
     * @param messageList  推送内容。直接传入对象列表
     */
    <T> void addCommonPushPersonal(Long liveId, Long userId, int msgType, List<T> messageList);
}
