package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * 用户优惠券使用状态枚举
 *
 * @author haojiahong
 * @date 2021-11-15
 */
public enum ConsumerDiscountUseStatusEnum {

    UNUSED(1, "待使用"),
    FREEZE(2, "已冻结"),
    USED(3, "已使用"),
    EXPIRE(4, "已过期"),
    ;

    private Integer status;
    private String desc;

    ConsumerDiscountUseStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static ConsumerDiscountUseStatusEnum getByCode(Integer code){
        if(code == null){
            return null;
        }

        ConsumerDiscountUseStatusEnum[] values = ConsumerDiscountUseStatusEnum.values();
        for(ConsumerDiscountUseStatusEnum status:values){
            if(status.getStatus().equals(code)){
                return status;
            }
        }
        return null;
    }
}
