package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/23 2:42 下午
 * 优惠券生效状态
 */
public enum DiscountValidStatus {

    VALID(1,"生效"),
    INVALID(2,"失效");

    private int code;
    private String desc;

    DiscountValidStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountValidStatus getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountValidStatus[] values = DiscountValidStatus.values();
        for(DiscountValidStatus status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
