package cn.com.duiba.mall.center.api.domain.enums.seckill;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/01/21 10:11.
 */
public enum SecKillActSkuConfEnableStatusEnum {
    STATUS_ENABLE(0, "有效"),
    STATUS_DISABLE(10, "已失效"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, SecKillActSkuConfEnableStatusEnum> enumMap = Maps.newHashMap();

    static {
        for(SecKillActSkuConfEnableStatusEnum enumVal: SecKillActSkuConfEnableStatusEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal);
        }
    }

    SecKillActSkuConfEnableStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SecKillActSkuConfEnableStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
