package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/17 10:07 上午
 * 优惠券种类
 */
public enum DiscountType {

    FULL_DECREASE(1,"满减券")
    //    本期不支持
//    REBATE(2,"满折券")
    ;

    private int code;
    private String desc;

    DiscountType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountType getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountType[] values = DiscountType.values();
        for(DiscountType status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
