package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/17 10:45 上午
 * 优惠券适用对象
 */
public enum DiscountUseObject {

    NO_LIMIT(0,"无限制"),
    WHITE_LIST_USER(1,"白名单用户");

    private int code;
    private String desc;

    DiscountUseObject(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountUseObject getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountUseObject[] values = DiscountUseObject.values();
        for(DiscountUseObject status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
