package cn.com.duiba.message.service.api.dto;

import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-10-16 16:53
 * @descript:
 * @version: 1.0
 */
@Data
public class LetterRequestDto implements Serializable {

    private static final long serialVersionUID = -4801216699298970440L;

    /**
     * 类型 - LetterTypeEnum
     */
    private Integer letterType;

    /**
     * 主题
     */
    private String subject;

    /**
     * 接收方ID
     */
    private String receiveId;

    /**
     * 状态：0-未读 1-已读
     */
    private Integer receiveStatus;

    /**
     * 开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date benginTime;

    /**
     * 结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    private Integer pageSize = 10;

    private Integer curPage = 1;

    private String orderBy = "gmt_create";

    private String sort = "desc";
}
