/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.BiasAndConfidenceDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.KaAdvertSupportInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class KaAdvertSupport {
    static double[] costWeightBucket = new double[]{50.0, 200.0, 500.0, 1000.0, 2000.0};
    static double[] costWeight = new double[]{0.0, 0.3, 0.8, 1.0, 1.0};
    static double[] costEffectWeightBucket = new double[]{10.0, 20.0, 50.0, 100.0, 200.0};
    static double[] costEffectWeight = new double[]{0.0, 0.3, 0.8, 1.0, 1.0};
    static double[] slotBiasBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1.0, 2.0, 3.0, 5.0};
    static double[] slotBiasWeight = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 10.0, 16.0};
    static double[] globalBiasBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.5, 1.0, 2.0};
    static double[] globalBiasWeight = new double[]{0.1, 0.12, 0.18, 0.5, 1.0, 1.0, 2.0};
    static double[] supportRatioBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.5, 0.8, 1.0};
    static double[] supportRatioWeight = new double[]{1.0, 0.8, 0.6, 0.3, 0.1, 0.1, 0.0};

    public static Double circuitBreakerNew(KaAdvertSupportInfo supportAdvert) {
        Double ret = 0.5;
        if (AssertUtil.isEmpty((Object)supportAdvert)) {
            return ret;
        }
        Double circuitBreakerFactor = KaAdvertSupport.circuitBreaker(supportAdvert);
        if (circuitBreakerFactor != null) {
            ret = circuitBreakerFactor;
        }
        return ret;
    }

    public static Double circuitBreaker(KaAdvertSupportInfo supportAdvert) {
        Double ret = null;
        if (AssertUtil.isEmpty((Object)supportAdvert)) {
            return ret;
        }
        KaAdvertSupportInfo adDo = supportAdvert;
        if (adDo != null && adDo.getSupportCost() != null && adDo.getSupportCost() > 0) {
            Double breakerScore;
            BiasAndConfidenceDo adBias = KaAdvertSupport.costBias(adDo.getConsume(), adDo.getConvertPV(), adDo.getSupportCost().intValue(), 1);
            BiasAndConfidenceDo adSlotBias = KaAdvertSupport.costBias(adDo.getAppConsume(), adDo.getAppConvertPV(), adDo.getSupportCost().intValue(), 2);
            ret = breakerScore = KaAdvertSupport.circuitBreaker(adBias, adSlotBias);
        }
        return ret;
    }

    public static Double circuitBreaker(BiasAndConfidenceDo adBias, BiasAndConfidenceDo adSlotBias) {
        Double breakerScore = 0.0;
        Double biasFactor = adBias.getBiasFactor() * adSlotBias.getBiasFactor();
        Double confidenceCostWeight = adBias.getConfidenceCostWeight() * adSlotBias.getConfidenceCostWeight();
        Double confidenceEffectWeight = adBias.getConfidenceCostEffectWeight() * adSlotBias.getConfidenceCostEffectWeight();
        breakerScore = biasFactor * confidenceCostWeight * confidenceEffectWeight;
        return DataUtil.formatDouble((Double)breakerScore, (int)3);
    }

    public static BiasAndConfidenceDo costBias(Long consume, Long landingPageClickPV, long aFee, int type) {
        BiasAndConfidenceDo ret = new BiasAndConfidenceDo();
        Double bias = 0.0;
        Double confidence = 0.0;
        Double costConfidenceWeight = 1.1;
        Double costEffectConfidenceWeight = 1.1;
        Double globalBiasFactor = 2.0;
        Double slotBiasFactor = 20.0;
        if (aFee > 0L) {
            if (consume == null) {
                consume = 0L;
            }
            if (landingPageClickPV == null) {
                landingPageClickPV = 0L;
            }
            if (consume <= 1L) {
                bias = 0.0;
                confidence = 0.0;
            } else if (landingPageClickPV == null || landingPageClickPV < 1L) {
                bias = DataUtil.division((Long)consume, (Long)aFee, (int)3);
                confidence = DataUtil.division((Long)consume, (Long)aFee, (int)2);
            } else {
                bias = DataUtil.division((Long)consume, (Long)(aFee * landingPageClickPV), (int)3) - 1.0;
                confidence = DataUtil.division((Long)consume, (Long)aFee, (int)2);
            }
            if (type == 1) {
                globalBiasFactor = KaAdvertSupport.getConfidenceWeight(bias, globalBiasBucket, globalBiasWeight, globalBiasFactor);
                ret.setBiasFactor(globalBiasFactor);
            } else {
                slotBiasFactor = KaAdvertSupport.getConfidenceWeight(bias, slotBiasBucket, slotBiasWeight, slotBiasFactor);
                ret.setBiasFactor(slotBiasFactor);
            }
            costConfidenceWeight = KaAdvertSupport.getConfidenceWeight(consume / 100L, costWeightBucket, costWeight, costConfidenceWeight);
            costEffectConfidenceWeight = KaAdvertSupport.getConfidenceWeight(confidence, costEffectWeightBucket, costEffectWeight, costEffectConfidenceWeight);
            ret.setConfidenceCostWeight(costConfidenceWeight);
            ret.setConfidenceCostEffectWeight(costEffectConfidenceWeight);
        }
        ret.setConsume(consume);
        ret.setBias(bias);
        ret.setConfidence(confidence);
        return ret;
    }

    public static Double biddingFactor(BudgetSmoothDo budgetSmoothDo, KaAdvertSupportInfo advertSupportInfoDo, String expNum) {
        Double ret = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertSupportInfoDo, budgetSmoothDo})) {
            return ret;
        }
        Double circuitBreakerFactor = KaAdvertSupport.circuitBreakerNew(advertSupportInfoDo);
        Double ratio = budgetSmoothDo.getRatio() == null ? 0.9 : budgetSmoothDo.getRatio();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ratio, circuitBreakerFactor})) {
            return advertSupportInfoDo.getLowerLimit();
        }
        if (circuitBreakerFactor < 0.99) {
            ratio = ratio < 0.99 ? ratio : 0.99;
            double supportRatio = KaAdvertSupport.supportRatio(advertSupportInfoDo);
            double factor = 0.5 * supportRatio + 0.5 * (1.0 - ratio);
            double smoothFactor = advertSupportInfoDo.getLowerLimit() + (advertSupportInfoDo.getUpperLimit() - advertSupportInfoDo.getLowerLimit()) * factor;
            smoothFactor = MathBase.noiseSmoother(smoothFactor, advertSupportInfoDo.getLowerLimit(), advertSupportInfoDo.getUpperLimit());
            if ("exp".equals(expNum) && advertSupportInfoDo.getIsWhite().booleanValue()) {
                double factor1 = KaAdvertSupport.division(advertSupportInfoDo.getPreCvr(), advertSupportInfoDo.getCvrLimit());
                factor1 = Math.max(Math.min(factor1, 1.5), 0.7);
                smoothFactor *= factor1;
                smoothFactor = MathBase.noiseSmoother(smoothFactor, 1.0, advertSupportInfoDo.getUpperLimit());
            }
            ret = DataUtil.formatDouble((Double)smoothFactor, (int)4);
        }
        return ret;
    }

    public static Double division(Double v1, Double v2) {
        return v1 != null && v2 != null && v2 != 0.0 ? v1 / v2 : 0.0;
    }

    public static Double supportRatio(KaAdvertSupportInfo advertSupportInfoDo) {
        double ret = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertSupportInfoDo})) {
            return ret;
        }
        if (advertSupportInfoDo.getSupportLaunch() == null || advertSupportInfoDo.getAppSupportLaunch() == null) {
            return ret;
        }
        double advertRatio = (double)advertSupportInfoDo.getSupportLaunch().longValue() / ((double)advertSupportInfoDo.getAdvertLaunchLimit().longValue() + 1.0);
        double appRatio = (double)advertSupportInfoDo.getSupportLaunch().longValue() / ((double)advertSupportInfoDo.getAdvertLaunchLimit().longValue() + 1.0);
        double advertRatioWeight = KaAdvertSupport.getConfidenceWeight(advertRatio, supportRatioBucket, supportRatioWeight, 0.1);
        double appRatioWeight = KaAdvertSupport.getConfidenceWeight(appRatio, supportRatioBucket, supportRatioWeight, 0.1);
        double ratioWeight = 0.7 * appRatioWeight + 0.3 * advertRatioWeight;
        return ratioWeight;
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;
        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = curWeight;
                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static void main(String[] args) {
        double i = KaAdvertSupport.getConfidenceWeight(0.4, globalBiasBucket, globalBiasWeight, 2.0);
        System.out.println(i);
        double slotBiasFactor = KaAdvertSupport.getConfidenceWeight(0.4, slotBiasBucket, slotBiasWeight, 2.0);
        System.out.println(slotBiasFactor);
        double costConfidenceWeight = KaAdvertSupport.getConfidenceWeight(500.0, costWeightBucket, costWeight, 1.1);
        double costEffectConfidenceWeight = KaAdvertSupport.getConfidenceWeight(50.0, costEffectWeightBucket, costEffectWeight, 1.1);
        System.out.println(costConfidenceWeight);
        System.out.println(costEffectConfidenceWeight);
    }
}

