/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.correct.IsotonicCalibrator;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class CvrCalibrator {
    public static void calibrate(AdBidParamsDo adBidParamsDo, IsotonicCalibrator calibrator, Double preCvr) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adBidParamsDo, calibrator, preCvr, calibrator.getLowerBound(), calibrator.getUpperBound()})) {
            return;
        }
        double rawCaliFactor = calibrator.calibrate(preCvr);
        double caliFactor = MathUtil.stdwithBoundary((double)rawCaliFactor, (double)calibrator.getLowerBound(), (double)calibrator.getUpperBound());
        Long fee = adBidParamsDo.getFee();
        Long feeNew = Math.round((double)fee.longValue() * caliFactor);
        adBidParamsDo.setFee(feeNew);
        adBidParamsDo.setCaliFee(feeNew);
        adBidParamsDo.setRawCaliFactor(rawCaliFactor);
        adBidParamsDo.setCaliFactor(caliFactor);
        adBidParamsDo.setCaliDim(calibrator.getDim());
        adBidParamsDo.setCaliTime(calibrator.getUpdateTime());
    }
}

