/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.coldstartandexplore.util.EncapsulateData;
import cn.com.duiba.nezha.alg.alg.coldstartandexplore.util.GetCvr;
import cn.com.duiba.nezha.alg.alg.coldstartandexplore.util.WeightingFunction;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrongTargetExplore {
    private static final Logger logger = LoggerFactory.getLogger(StrongTargetExplore.class);
    private static final Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>(){

        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) {
            return r2.rectifyBid - r1.rectifyBid >= 0.0 ? 1 : -1;
        }
    };

    public static List<STEResultDo> STE(STEParams steParams, List<STEInfoDo> steInfoDoList) {
        ArrayList<STEResultDo> res = new ArrayList<STEResultDo>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{steParams, steInfoDoList})) {
            return res;
        }
        PriorityQueue<RectifyNdAdvertResInfo> candis = new PriorityQueue<RectifyNdAdvertResInfo>(iComparator);
        for (STEInfoDo steInfoDo : steInfoDoList) {
            double curRectifyBid = 0.0;
            double exposureFactor = 1.0;
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            Map<String, Object> AdjustCVRRes = GetCvr.getAdjustCVR(steParams, steInfoDo);
            double adjustWeight = (Double)AdjustCVRRes.get("adjustWeight");
            double adjustCvr = (Double)AdjustCVRRes.get("adjustCvr");
            String paramType = (Double)AdjustCVRRes.get("paramType") == 1.0 ? "firstSet" : "secondSet";
            double preCtr = steInfoDo.getPreCtr();
            Long bid = steInfoDo.getBid();
            Long hisSlotAdvExpose = steInfoDo.getHisExpose();
            Integer exposeConfidenceThreshold2 = paramType.equals("firstSet") ? steParams.getExposeConfidenceThreshold2() : steParams.getExposeConfidenceThresholdSet5();
            if (hisSlotAdvExpose <= (long)exposeConfidenceThreshold2.intValue()) {
                exposureFactor = WeightingFunction.functionOfExpose(hisSlotAdvExpose, steParams, paramType);
                curRectifyBid = preCtr * adjustCvr * (double)bid.longValue() * exposureFactor;
            } else {
                curRectifyBid = preCtr * adjustCvr * (double)bid.longValue();
            }
            rectifyNdAdvertResInfo.steResult = EncapsulateData.fillData(steInfoDo, exposureFactor, 1.0, adjustWeight, adjustCvr, 1);
            rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
            candis.add(rectifyNdAdvertResInfo);
        }
        int lengthOfCandis = candis.size();
        for (int idx = 0; idx < lengthOfCandis; ++idx) {
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo = (RectifyNdAdvertResInfo)candis.poll();
            assert (curRectifyNdAdvertResInfo != null);
            Double upLimit = curRectifyNdAdvertResInfo.steResult.getStrTarExpAdjFacUpLimit();
            curRectifyNdAdvertResInfo.steResult.setAdjustFactor(Math.max(upLimit * WeightingFunction.decreaseFunc(idx, steParams), 1.0));
            curRectifyNdAdvertResInfo.steResult.setRankInCandis(idx + 1);
            res.add(curRectifyNdAdvertResInfo.steResult);
        }
        return res;
    }

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;
        STEResultDo steResult;

        RectifyNdAdvertResInfo() {
        }
    }
}

