/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.correct;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import java.util.Arrays;

public class IsotonicCalibrator {
    private static final String redisKeyPrefix = "NZ_CALIBRATION";
    private long targetConvertCount;
    private String dim;
    private String redisKey;
    private String updateTime;
    private double[] boundaries;
    private double[] predictions;
    private Double lowerBound;
    private Double upperBound;

    public static String getModelRedisKey(Long slotId, String abTestId, Long advertId) {
        String slotAlgPrefix = AdBidParamsDo.concatSlotAlgPrefix(slotId, abTestId);
        return IsotonicCalibrator.getModelRedisKeyWithSlotAlgPrefix(slotAlgPrefix, advertId);
    }

    public static String getModelRedisKeyWithSlotAlgPrefix(String slotAlgPrefix, Long advertId) {
        if (slotAlgPrefix == null) {
            return redisKeyPrefix;
        }
        if (advertId == null) {
            return "NZ_CALIBRATION_" + slotAlgPrefix;
        }
        return "NZ_CALIBRATION_" + slotAlgPrefix + "_" + advertId;
    }

    public void valid() throws RuntimeException {
        int i;
        int sizeB = this.boundaries.length;
        int sizeP = this.predictions.length;
        if (sizeB != sizeP) {
            throw new RuntimeException("the length of boundaries and predictions must be same");
        }
        for (i = 1; i < this.boundaries.length; ++i) {
            if (!(this.boundaries[i - 1] > this.boundaries[i])) continue;
            throw new RuntimeException("Isotonic need monotone boundaries and predictions");
        }
        for (i = 1; i < this.predictions.length; ++i) {
            if (!(this.predictions[i - 1] > this.predictions[i])) continue;
            throw new RuntimeException("Isotonic need monotone boundaries and predictions");
        }
    }

    private double linearInterpolation(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public double calibrateRatio(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries, testData);
        int insertIndex = -foundIndex - 1;
        if (insertIndex == 0) {
            return this.predictions[0];
        }
        if (insertIndex == this.boundaries.length) {
            return this.predictions[this.predictions.length - 1];
        }
        if (foundIndex < 0) {
            return this.linearInterpolation(this.boundaries[insertIndex - 1], this.predictions[insertIndex - 1], this.boundaries[insertIndex], this.predictions[insertIndex], testData);
        }
        return this.predictions[foundIndex];
    }

    public double calibrate(double testData) {
        double rawOutput = this.calibrateRatio(testData);
        return rawOutput / (testData + 1.0E-12);
    }

    public long getTargetConvertCount() {
        return this.targetConvertCount;
    }

    public String getDim() {
        return this.dim;
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public double[] getBoundaries() {
        return this.boundaries;
    }

    public double[] getPredictions() {
        return this.predictions;
    }

    public Double getLowerBound() {
        return this.lowerBound;
    }

    public Double getUpperBound() {
        return this.upperBound;
    }

    public void setTargetConvertCount(long targetConvertCount) {
        this.targetConvertCount = targetConvertCount;
    }

    public void setDim(String dim) {
        this.dim = dim;
    }

    public void setRedisKey(String redisKey) {
        this.redisKey = redisKey;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setBoundaries(double[] boundaries) {
        this.boundaries = boundaries;
    }

    public void setPredictions(double[] predictions) {
        this.predictions = predictions;
    }

    public void setLowerBound(Double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(Double upperBound) {
        this.upperBound = upperBound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsotonicCalibrator)) {
            return false;
        }
        IsotonicCalibrator other = (IsotonicCalibrator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTargetConvertCount() != other.getTargetConvertCount()) {
            return false;
        }
        String this$dim = this.getDim();
        String other$dim = other.getDim();
        if (this$dim == null ? other$dim != null : !this$dim.equals(other$dim)) {
            return false;
        }
        String this$redisKey = this.getRedisKey();
        String other$redisKey = other.getRedisKey();
        if (this$redisKey == null ? other$redisKey != null : !this$redisKey.equals(other$redisKey)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        if (!Arrays.equals(this.getBoundaries(), other.getBoundaries())) {
            return false;
        }
        if (!Arrays.equals(this.getPredictions(), other.getPredictions())) {
            return false;
        }
        Double this$lowerBound = this.getLowerBound();
        Double other$lowerBound = other.getLowerBound();
        if (this$lowerBound == null ? other$lowerBound != null : !((Object)this$lowerBound).equals(other$lowerBound)) {
            return false;
        }
        Double this$upperBound = this.getUpperBound();
        Double other$upperBound = other.getUpperBound();
        return !(this$upperBound == null ? other$upperBound != null : !((Object)this$upperBound).equals(other$upperBound));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IsotonicCalibrator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $targetConvertCount = this.getTargetConvertCount();
        result = result * 59 + (int)($targetConvertCount >>> 32 ^ $targetConvertCount);
        String $dim = this.getDim();
        result = result * 59 + ($dim == null ? 43 : $dim.hashCode());
        String $redisKey = this.getRedisKey();
        result = result * 59 + ($redisKey == null ? 43 : $redisKey.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBoundaries());
        result = result * 59 + Arrays.hashCode(this.getPredictions());
        Double $lowerBound = this.getLowerBound();
        result = result * 59 + ($lowerBound == null ? 43 : ((Object)$lowerBound).hashCode());
        Double $upperBound = this.getUpperBound();
        result = result * 59 + ($upperBound == null ? 43 : ((Object)$upperBound).hashCode());
        return result;
    }

    public String toString() {
        return "IsotonicCalibrator(targetConvertCount=" + this.getTargetConvertCount() + ", dim=" + this.getDim() + ", redisKey=" + this.getRedisKey() + ", updateTime=" + this.getUpdateTime() + ", boundaries=" + Arrays.toString(this.getBoundaries()) + ", predictions=" + Arrays.toString(this.getPredictions()) + ", lowerBound=" + this.getLowerBound() + ", upperBound=" + this.getUpperBound() + ")";
    }
}

