/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.title;

import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import java.io.Serializable;

public class ActTitleStatModel
implements Serializable {
    public static ActTitleStatDo merge(ActTitleStatDo historyStatDo, ActTitleStatDo hourStatDo) {
        ActTitleStatDo ret = new ActTitleStatDo();
        if (historyStatDo == null) {
            historyStatDo = new ActTitleStatDo();
        }
        if (hourStatDo == null) {
            hourStatDo = new ActTitleStatDo();
        }
        Double decayFactorHis = 0.9;
        Double decayFactorCur = 0.1;
        Long visitPv = ActTitleStatModel.mergeNew(historyStatDo.getVisitPv(), hourStatDo.getVisitPv(), decayFactorHis, decayFactorCur);
        Long joinPv = ActTitleStatModel.mergeNew(historyStatDo.getJoinPv(), hourStatDo.getJoinPv(), decayFactorHis, decayFactorCur);
        Long launchCnt = ActTitleStatModel.mergeNew(historyStatDo.getLaunchCnt(), hourStatDo.getLaunchCnt(), decayFactorHis, decayFactorCur);
        Long clickPv = ActTitleStatModel.mergeNew(historyStatDo.getClickPv(), hourStatDo.getClickPv(), decayFactorHis, decayFactorCur);
        Long chargeFees = ActTitleStatModel.mergeNew(historyStatDo.getChargeFees(), hourStatDo.getChargeFees(), decayFactorHis, decayFactorCur);
        Long convertPv = ActTitleStatModel.mergeNew(historyStatDo.getConvertPv(), hourStatDo.getConvertPv(), decayFactorHis, decayFactorCur);
        ret.setSlotId(hourStatDo.getSlotId());
        ret.setDsm2A(historyStatDo.getDsm2A());
        ret.setActivityPage(hourStatDo.getActivityPage());
        ret.setSlotId(hourStatDo.getSlotId());
        ret.setTitleId(hourStatDo.getTitleId());
        ret.setVisitPv(visitPv);
        ret.setJoinPv(joinPv);
        ret.setLaunchCnt(launchCnt);
        ret.setClickPv(clickPv);
        ret.setChargeFees(chargeFees);
        ret.setConvertPv(convertPv);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        return ret;
    }

    public static Double getRpm(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null && statDo.getVisitPv() != null && statDo.getVisitPv() > 300L && statDo.getChargeFees() != null && statDo.getChargeFees() > 300L) {
            ret = DataUtil.division((Long)statDo.getChargeFees(), (Long)(statDo.getVisitPv() + 1L), (int)5);
        }
        return ret;
    }

    public static Double getJpv(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null && statDo.getVisitPv() != null && statDo.getVisitPv() > 300L && statDo.getJoinPv() != null && statDo.getJoinPv() > 100L) {
            ret = DataUtil.division((Long)statDo.getJoinPv(), (Long)(statDo.getVisitPv() + 1L), (int)5);
        }
        return ret;
    }

    public static Double getCpv(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null && statDo.getVisitPv() != null && statDo.getVisitPv() > 300L && statDo.getClickPv() != null && statDo.getClickPv() > 100L) {
            ret = DataUtil.division((Long)statDo.getClickPv(), (Long)(statDo.getVisitPv() + 1L), (int)5);
        }
        return ret;
    }

    public static Double getApv(ActTitleStatDo statDo) {
        Double ret = null;
        if (statDo != null && statDo.getVisitPv() != null && statDo.getVisitPv() > 300L && statDo.getConvertPv() != null && statDo.getConvertPv() > 10L) {
            ret = DataUtil.division((Long)statDo.getConvertPv(), (Long)(statDo.getVisitPv() + 1L), (int)5);
        }
        return ret;
    }

    public static Long mergeNew(Long v1, Long v2, Double decayFactor1, Double decayFactor2) {
        if (v1 == null) {
            v1 = 0L;
        }
        if (v2 == null) {
            v2 = 0L;
        }
        return DataUtil.double2Long((Double)(decayFactor1 * (double)v1.longValue() + decayFactor2 * (double)v2.longValue()));
    }

    public static Double getDecayFactor(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = 1.0 - 0.3 * Math.min(((double)visitPv.longValue() + 0.0) / (double)basePv.longValue(), 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorHistory(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = Math.min(((double)basePv.longValue() + 0.0) / (double)visitPv.longValue(), 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorCurrent(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = Math.min(1.0, ((double)basePv.longValue() + 0.0) / (double)visitPv.longValue());
        }
        return ret;
    }
}

