/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.advertsupport;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.HashMap;
import java.util.Map;

public class SupportData {
    Long exposure = 0L;
    Long click = 0L;
    Map<Integer, Long> conv = new HashMap<Integer, Long>();
    Long consume = 0L;
    Long ocpcConsume = 0L;
    Double costBias = 0.0;
    Double cost;

    public static double division(Long v1, Long v2) {
        return v1 != null && v2 != null && v2 != 0L ? v1.doubleValue() / v2.doubleValue() : 0.0;
    }

    public double getCtr() {
        if (this.exposure <= 0L) {
            return 0.0;
        }
        return DataUtil.formatDouble((Double)((double)this.click.longValue() * 1.0 / (double)this.exposure.longValue()), (int)4);
    }

    public double getWCtr(double faithLevel) {
        return DataUtil.formatDouble((Double)DataUtil.calWilsonScore((Long)this.exposure, (Long)this.click, (double)faithLevel), (int)4);
    }

    public double getCvr(Integer convertSubtype) {
        if (this.click <= 0L) {
            return 0.0;
        }
        return DataUtil.formatDouble((Double)SupportData.division(this.conv.getOrDefault(convertSubtype, 0L), this.click), (int)4);
    }

    public double getWCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble((Double)DataUtil.calWilsonScore((Long)this.click, (Long)this.conv.getOrDefault(convertSubtype, 0L), (double)faithLevel), (int)4);
    }

    public double getCtCvr(Integer convertSubtype) {
        if (this.exposure <= 0L) {
            return 0.0;
        }
        return DataUtil.formatDouble((Double)SupportData.division(this.conv.getOrDefault(convertSubtype, 0L), this.exposure), (int)4);
    }

    public double getWCtCvr(Integer convertSubtype, double faithLevel) {
        return DataUtil.formatDouble((Double)DataUtil.calWilsonScore((Long)this.exposure, (Long)this.conv.getOrDefault(convertSubtype, 0L), (double)faithLevel), (int)4);
    }

    public static void main(String[] args) {
        SupportData supportData = new SupportData();
        supportData.setExposure(100000L);
        supportData.setClick(100L);
        HashMap<Integer, Long> conv = new HashMap<Integer, Long>();
        conv.put(0, 20L);
        conv.put(2, 10L);
        conv.put(3, 5L);
        supportData.setConv(conv);
        System.out.println(supportData.getCtr());
        System.out.println(supportData.getWCtr(2.0));
        System.out.println(supportData.getCvr(0));
        System.out.println(supportData.getWCvr(0, 2.0));
        System.out.println(supportData.getCtCvr(0));
        System.out.println(supportData.getWCtCvr(0, 2.0));
    }

    public Long getExposure() {
        return this.exposure;
    }

    public Long getClick() {
        return this.click;
    }

    public Map<Integer, Long> getConv() {
        return this.conv;
    }

    public Long getConsume() {
        return this.consume;
    }

    public Long getOcpcConsume() {
        return this.ocpcConsume;
    }

    public Double getCostBias() {
        return this.costBias;
    }

    public Double getCost() {
        return this.cost;
    }

    public void setExposure(Long exposure) {
        this.exposure = exposure;
    }

    public void setClick(Long click) {
        this.click = click;
    }

    public void setConv(Map<Integer, Long> conv) {
        this.conv = conv;
    }

    public void setConsume(Long consume) {
        this.consume = consume;
    }

    public void setOcpcConsume(Long ocpcConsume) {
        this.ocpcConsume = ocpcConsume;
    }

    public void setCostBias(Double costBias) {
        this.costBias = costBias;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupportData)) {
            return false;
        }
        SupportData other = (SupportData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$exposure = this.getExposure();
        Long other$exposure = other.getExposure();
        if (this$exposure == null ? other$exposure != null : !((Object)this$exposure).equals(other$exposure)) {
            return false;
        }
        Long this$click = this.getClick();
        Long other$click = other.getClick();
        if (this$click == null ? other$click != null : !((Object)this$click).equals(other$click)) {
            return false;
        }
        Map<Integer, Long> this$conv = this.getConv();
        Map<Integer, Long> other$conv = other.getConv();
        if (this$conv == null ? other$conv != null : !((Object)this$conv).equals(other$conv)) {
            return false;
        }
        Long this$consume = this.getConsume();
        Long other$consume = other.getConsume();
        if (this$consume == null ? other$consume != null : !((Object)this$consume).equals(other$consume)) {
            return false;
        }
        Long this$ocpcConsume = this.getOcpcConsume();
        Long other$ocpcConsume = other.getOcpcConsume();
        if (this$ocpcConsume == null ? other$ocpcConsume != null : !((Object)this$ocpcConsume).equals(other$ocpcConsume)) {
            return false;
        }
        Double this$costBias = this.getCostBias();
        Double other$costBias = other.getCostBias();
        if (this$costBias == null ? other$costBias != null : !((Object)this$costBias).equals(other$costBias)) {
            return false;
        }
        Double this$cost = this.getCost();
        Double other$cost = other.getCost();
        return !(this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SupportData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $exposure = this.getExposure();
        result = result * 59 + ($exposure == null ? 43 : ((Object)$exposure).hashCode());
        Long $click = this.getClick();
        result = result * 59 + ($click == null ? 43 : ((Object)$click).hashCode());
        Map<Integer, Long> $conv = this.getConv();
        result = result * 59 + ($conv == null ? 43 : ((Object)$conv).hashCode());
        Long $consume = this.getConsume();
        result = result * 59 + ($consume == null ? 43 : ((Object)$consume).hashCode());
        Long $ocpcConsume = this.getOcpcConsume();
        result = result * 59 + ($ocpcConsume == null ? 43 : ((Object)$ocpcConsume).hashCode());
        Double $costBias = this.getCostBias();
        result = result * 59 + ($costBias == null ? 43 : ((Object)$costBias).hashCode());
        Double $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        return result;
    }

    public String toString() {
        return "SupportData(exposure=" + this.getExposure() + ", click=" + this.getClick() + ", conv=" + this.getConv() + ", consume=" + this.getConsume() + ", ocpcConsume=" + this.getOcpcConsume() + ", costBias=" + this.getCostBias() + ", cost=" + this.getCost() + ")";
    }
}

