/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.api.facade.recall.channel;

import cn.com.duiba.nezha.alg.api.dto.base.BaseAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.AppIndustryGeneralAdvertDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.AppIndustryGeneralRedisDTO;
import cn.com.duiba.nezha.alg.api.dto.recall.AppIndustryGeneralRequest;
import cn.com.duiba.nezha.alg.api.dto.recall.RecallChannelResult;
import cn.com.duiba.nezha.alg.api.enums.RecallEnums;
import cn.com.duiba.nezha.alg.api.facade.recall.AbstractRecallChanelFacade;
import cn.com.duiba.nezha.alg.api.facade.recall.channel.AppIndustryGeneralRecallChannelFacade;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.bag.HashBag;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppIndustryGeneralRecallChannelFacadeImpl
extends AbstractRecallChanelFacade<AppIndustryGeneralAdvertDTO, AppIndustryGeneralRequest>
implements AppIndustryGeneralRecallChannelFacade {
    static Logger logger = LoggerFactory.getLogger(AppIndustryGeneralRecallChannelFacadeImpl.class);

    public RecallEnums.RecallChannelType getType() {
        return RecallEnums.RecallChannelType.AppIndustryGeneral;
    }

    @Override
    public Map<String, RecallChannelResult> execute(Map<String, AppIndustryGeneralAdvertDTO> appIndustryGeneralAdvertDTOMap, AppIndustryGeneralRequest appIndustryGeneralRequest) {
        HashMap<String, RecallChannelResult> res = new HashMap<String, RecallChannelResult>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{appIndustryGeneralAdvertDTOMap, appIndustryGeneralRequest})) {
            return res;
        }
        Map appIndustryGeneRecallInitRes = appIndustryGeneralRequest.getRedisMap();
        Map nums = appIndustryGeneralRequest.getNum();
        Map threshold = appIndustryGeneralRequest.getThreshold();
        Set advertIds = appIndustryGeneralAdvertDTOMap.values().stream().map(BaseAdvertDTO::getAdvertId).collect(Collectors.toSet());
        Map adOrientMap = appIndustryGeneralAdvertDTOMap.values().stream().collect(Collectors.groupingBy(BaseAdvertDTO::getAdvertId, Collectors.mapping(BaseAdvertDTO::getPackageId, Collectors.toList())));
        HashMap helperMap = new HashMap();
        for (Map.Entry entry : appIndustryGeneRecallInitRes.entrySet()) {
            String key = (String)entry.getKey();
            String curIndex = key.split("_")[2];
            List curAppIndustryGeneralRedisDTOList = (List)entry.getValue();
            if (!AssertUtil.isNotEmpty((Collection)curAppIndustryGeneralRedisDTOList)) continue;
            List retained = curAppIndustryGeneralRedisDTOList.stream().filter(pkg -> pkg != null && advertIds.contains(pkg.getAdvertId())).collect(Collectors.toList());
            for (AppIndustryGeneralRedisDTO ig : retained) {
                HashMap<Long, Map<String, Double>> curAdRes = new HashMap<Long, Map<String, Double>>();
                Map<String, Double> curInnerRes = this.getInnerVal(ig, curIndex, key);
                Long CurAdId = ig.getAdvertId();
                curAdRes.put(CurAdId, curInnerRes);
                if (helperMap.containsKey(curIndex)) {
                    if (((Map)helperMap.get(curIndex)).containsKey(CurAdId)) {
                        ((Map)((Map)helperMap.get(curIndex)).get(CurAdId)).putAll(curInnerRes);
                        continue;
                    }
                    ((Map)helperMap.get(curIndex)).putAll(curAdRes);
                    continue;
                }
                helperMap.put(curIndex, curAdRes);
            }
        }
        for (Map.Entry entry : helperMap.entrySet()) {
            ArrayList<RecallChannelResult> curIndexRecallResList = new ArrayList<RecallChannelResult>();
            String index = (String)entry.getKey();
            Map advertRecallResMap = (Map)entry.getValue();
            for (Map.Entry entry1 : advertRecallResMap.entrySet()) {
                RecallChannelResult curRecallRes = new RecallChannelResult();
                Long advertId = (Long)entry1.getKey();
                Map advertBeRecalledRes = (Map)entry1.getValue();
                Double threeDays = this.getCurDimsScore(advertBeRecalledRes, index, "3day", "global", appIndustryGeneralRequest.getSlotId().toString());
                Double oneDays = this.getCurDimsScore(advertBeRecalledRes, index, "1day", "global", appIndustryGeneralRequest.getSlotId().toString());
                Double oneHour = this.getCurDimsScore(advertBeRecalledRes, index, "1hour", "global", appIndustryGeneralRequest.getSlotId().toString());
                Double[] scoreList = new Double[]{oneHour, oneDays, threeDays};
                Double finalScore = this.getFinalScore(Arrays.asList(scoreList));
                curRecallRes.setAdvertId(advertId);
                curRecallRes.setScore(finalScore);
                curIndexRecallResList.add(curRecallRes);
            }
            List innerTmpRes = curIndexRecallResList.stream().filter(curIndexRecallRes -> curIndexRecallRes.getScore() > (Double)threshold.get(index)).sorted(Comparator.comparing(RecallChannelResult::getScore).reversed()).limit(((Integer)nums.get(index)).intValue()).collect(Collectors.toList());
            for (RecallChannelResult rcr : innerTmpRes) {
                RecallChannelResult finalOneRecallRes = new RecallChannelResult();
                List orientList = adOrientMap.get(rcr.getAdvertId());
                for (Long orient : orientList) {
                    finalOneRecallRes.setAdvertId(rcr.getAdvertId());
                    finalOneRecallRes.setPackageId(orient);
                    finalOneRecallRes.setScore(rcr.getScore());
                    finalOneRecallRes.setIndex(index);
                    res.put(finalOneRecallRes.buildKey(), finalOneRecallRes);
                }
            }
        }
        return res;
    }

    private Map<String, Double> getInnerVal(AppIndustryGeneralRedisDTO appIndustryGeneralRedisDTO, String type, String key) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{appIndustryGeneralRedisDTO, type, key})) {
            return res;
        }
        if ("ctr".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getCtrScore());
        } else if ("cvr0".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getCvrScore0());
        } else if ("cvr1".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getCvrScore1());
        } else if ("dCvr".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getDCvrScore());
        } else if ("consume".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getConsumeScore());
        } else if ("weight0".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getWeightScore0());
        } else if ("weight1".equals(type)) {
            res.put(key, appIndustryGeneralRedisDTO.getWeightScore1());
        } else {
            logger.info("Wrong input type. Please enter type in array('ctr', 'cvr0', 'cvr1', 'dCvr', 'consume', 'weight0', 'weight1')");
            System.out.println("Wrong input type. Please enter type in array('ctr', 'cvr0', 'cvr1', 'dCvr', 'consume', 'weight0', 'weight1')");
        }
        return res;
    }

    private List<String> getKey(String index, List<String> timeDims, List<String> dataDims) {
        ArrayList<String> res = new ArrayList<String>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{index, timeDims, dataDims})) {
            return res;
        }
        for (String time : timeDims) {
            dataDims.forEach(data -> res.add(Joiner.on((String)"_").join((Object)"NZ_A4", (Object)index, new Object[]{"app", time, data})));
        }
        return res;
    }

    private String getKey(String index, String timeDim, String dataDim) {
        return AssertUtil.isAnyEmpty((Object[])new Object[]{index, timeDim, dataDim}) ? null : Joiner.on((String)"_").join((Object)"NZ_A4", (Object)index, new Object[]{"app", timeDim, dataDim});
    }

    private Double getCurDimsScore(Map<String, Double> advertBeRecalledRes, String index, String timeDim, String global, String slot) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertBeRecalledRes, index, timeDim, global, slot})) {
            return 0.0;
        }
        String globalKey = this.getKey(index, timeDim, global);
        String slotKey = this.getKey(index, timeDim, slot);
        if (advertBeRecalledRes.containsKey(slotKey)) {
            return advertBeRecalledRes.getOrDefault(slotKey, 0.0);
        }
        return advertBeRecalledRes.getOrDefault(globalKey, 0.0);
    }

    private Double getFinalScore(List<Double> scoreList) {
        HashBag bag = new HashBag(scoreList);
        int nonZero = scoreList.size() - bag.getCount((Object)0.0);
        return nonZero != 0 ? (Constance.weight1Hour * scoreList.get(0) + Constance.weight1Day * scoreList.get(1) + Constance.weight3Day * scoreList.get(2)) / (double)nonZero : 0.0;
    }

    @Test
    public Map<String, RecallChannelResult> test1() {
        HashMap<String, RecallChannelResult> res = new HashMap<String, RecallChannelResult>();
        HashMap appIndustryGeneralAdvertDTOMap = new HashMap();
        return res;
    }

    private static class Constance {
        private static final String prefix = "NZ_A4";
        static Double weight3Day = 0.96;
        static Double weight1Day = 0.98;
        static Double weight1Hour = 1.0;

        private Constance() {
        }
    }
}

