package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFilterInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowFilterDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxFlowInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;


public class AdxFlowFiltering {

    /**
     * 算法接口1-流量预过滤
     *
     * @param flowInfo adx流量信息
     * @param filterInfo adx流量过滤-定时任务结果
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(AdxFlowFiltering.class);

    public static AdxFlowFilterDo getFlowFiltering(AdxFlowInfoDo flowInfo,
                                                   AdxFilterInfoDo filterInfo) {

        AdxFlowFilterDo ret = new AdxFlowFilterDo();

        try {

            Integer flowFilterLabel = 0;        //流量过滤标记(0：不过滤；1：过滤)
            Integer preInterval = null;         //ctr预估区间
            Integer filterIndex = 1;            //abtest分流标记(1：对比组；2：测试组)

            Double filterRate = 0.0;            //过滤比例
            Long testRate = 0L;                 //abtest分流-测试组切流(百分数)
            boolean isConfident = false;        //统计指标是否置信


            if (AssertUtil.isAllNotEmpty(flowInfo, filterInfo)) {

                //1.获取测试组切流(百分数)
                testRate = AdxStatData.getNormalValue(flowInfo.getTestRate(), 0L,0L, 100L);

                //2.获取ctr预估区间preInterval
                Double preValue = flowInfo.getCurrentPreValue(); //模型CTR预估值
                preInterval = AdxStatData.getPreInterval(preValue);

                //3.获取过滤比例
                Map<Integer, Double> filterMap = filterInfo.getFilterMap();
                if (AssertUtil.isAllNotEmpty(preInterval, filterMap)) {
                    filterRate = AdxStatData.nullToDefault(filterMap.get(preInterval),0.0);
                }

                //4.获取统计数据
                AdxIndexStatDo ideaDayStats = flowInfo.getIdeaDayStats();
                AdxIndexStatsDo ideaDayComputes = AdxStatData.adxIndexCompute(ideaDayStats);
                isConfident = ideaDayComputes.getConfident();


                //5.数据置信，测试组切流，判断流量过滤
                if (isConfident) {

                    double random = Math.random();
                    if (random < DataUtil.division(testRate, 100L)) {
                        filterIndex = 2;

                        double random2 = Math.random();
                        if (random2 < filterRate) {
                            flowFilterLabel = 1;
                        }
                    }

                }

            }

            ret.setFlowFilterLabel(flowFilterLabel);
            ret.setPreInterval(preInterval);
            ret.setFilterIndex(filterIndex);


        } catch (Exception e) {
            logger.error("AdxFlowFiltering.getFlowFiltering error:" + e);

        }

        return ret;

    }
}

