package cn.com.duiba.nezha.alg.alg.intercept;

import cn.com.duiba.nezha.alg.alg.vo.title.ActTitleStatDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.ActInterceptStatDo;

import java.io.Serializable;

/**
 * 响应插件-统计对象
 */
public class ActInterceptStatModel implements Serializable {




    public static Double getRpm(ActInterceptStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getChargeFees() != null &&
                    statDo.getChargeFees() > 300) {
                ret = DataUtil.division(statDo.getChargeFees(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }

    public static Double getJpv(ActInterceptStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getJoinPv() != null &&
                    statDo.getJoinPv() > 100) {
                ret = DataUtil.division(statDo.getJoinPv(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }

    public static Double getCpv(ActInterceptStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getClickPv() != null &&
                    statDo.getClickPv() > 100) {
                ret = DataUtil.division(statDo.getClickPv(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }


    public static Double getApv(ActInterceptStatDo statDo) {
        Double ret = null;
        if (statDo != null) {
            if (statDo.getVisitPv() != null &&
                    statDo.getVisitPv() > 300 &&
                    statDo.getConvertPv() != null &&
                    statDo.getConvertPv() > 10) {
                ret = DataUtil.division(statDo.getConvertPv(), statDo.getVisitPv() + 1, 5);
            }
        }
        return ret;
    }


    /**
     * 融合-去除误差
     *
     * @param v1
     * @param v2
     * @param decayFactor1
     * @return
     */
    public static Long mergeNew(Long v1, Long v2, Double decayFactor1, Double decayFactor2) {

        if (v1 == null) {
            v1 = 0L;
        }
        if (v2 == null) {
            v2 = 0L;
        }

        return DataUtil.double2Long(decayFactor1 * v1 + decayFactor2 * v2);

    }

    public static Double getDecayFactor(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = 1.0 - 0.3 * Math.min((visitPv + 0.0) / basePv, 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorHistory(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {
            ret = Math.min((basePv + 0.0) / (visitPv), 1.0);
        }
        return ret;
    }

    public static Double getDecayFactorCurrent(Long visitPv, Long basePv) {
        Double ret = 1.0;
        if (visitPv != null) {

            ret = Math.min(1.0, (basePv + 0.0) / visitPv);
//            if (visitPv > 200 && visitPv < 500) {
//                ret = 2.0;
//            }

        }
        return ret;
    }
}
