package cn.com.duiba.nezha.alg.alg.sdk;

import cn.com.duiba.nezha.alg.alg.vo.sdk.PkInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkDirectlyPkDo;
import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;

public class SdkDirectlyPk {


    /**
     * 互动活动&直投广告收益ecpm PK
     *
     * @param pkList         广告位id，活动素材id，广告素材id
     * @param ideaStatDoMap  实时统计数据 (key:实际投放类型（0:互动活动/3:直投广告）
     * @return
     */

    private static final Logger logger = LoggerFactory.getLogger(SdkDirectlyPk.class);

    public static SdkDirectlyPkDo getPk(PkInfoDo pkList,
                                        Map<Integer, SdkStatDo> ideaStatDoMap) {

        SdkDirectlyPkDo ret = new SdkDirectlyPkDo();

        try {

            Long winId = null;
            Integer winType = 0;
            Double actEcpm = null, adEcpm = null;

            if (AssertUtil.isNotEmpty(pkList)) {

                Long actMaterId = pkList.getActivityMaterialId();
                Long adMaterId = pkList.getAdvertMaterialId();

                if (AssertUtil.isAllNotEmpty(actMaterId, adMaterId)) {

                    //默认随机胜出
                    winId = actMaterId;
                    double random1 = Math.random();
                    if (random1 <= 0.5) {
                        winId = adMaterId;
                        winType = 3;
                    }

                    if (AssertUtil.isNotEmpty(ideaStatDoMap)) {

                        //获取统计指标
                        SdkStatDo actMaterInfo = ideaStatDoMap.get(0);
                        SdkStatDo adMaterInfo = ideaStatDoMap.get(3);
                        if (AssertUtil.isAllNotEmpty(actMaterInfo, adMaterInfo)) {
                            SdkIndexStatsDo actStats = actMaterInfo.getSlotHourStats();
                            SdkIndexStatsDo adStats = adMaterInfo.getSlotHourStats();
                            actEcpm  = SdkStatData.sdkIndexCompute(actStats).getEcpm();
                            adEcpm  = SdkStatData.sdkIndexCompute(adStats).getEcpm();
                        }


                        if (AssertUtil.isAllNotEmpty(actEcpm, adEcpm)) {

                            // pk标准：ecpm高者按90%概率胜出(投放类型维度)
                            if (SdkStatData.isLarger(adEcpm, actEcpm)) {

                                double random2 = Math.random();
                                if (random2 <= 0.9) {
                                    winId = adMaterId;
                                    winType = 3;
                                }
                            }
                        }
                    }
                }
            }

            ret.setWinId(winId);
            ret.setWinType(winType);
            ret.setActivityEcpm(actEcpm);
            ret.setAdvertEcpm(adEcpm);

        } catch (Exception e) {
            logger.error("SdkDirectlyPk.getPk error:" + e);

        }

        return ret;
    }


}
