package cn.com.duiba.nezha.alg.alg.sdk;

import cn.com.duiba.nezha.alg.alg.vo.sdk.SdkIndexStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;

public class SdkStatData {


    /**
     * 缺失情况，重置为defaultValue
     *
     * @param value
     * @param defaultValue
     * @return 默认值
     */
    public static Long nullToMinDefault(Long value, Long defaultValue) {

        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }


    /**
     * 判断是否比阈值大
     *
     * @param value1
     * @param value2
     * @return
     */
    public static boolean isLarger(Long value1, Long value2) {

        boolean ret = false;

        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }

        return ret;
    }



    /**
     * 判断是否比阈值大
     *
     * @param value1
     * @param value2
     * @return
     */
    public static boolean isLarger(Double value1, Double value2) {

        boolean ret = false;

        if (value1 != null && value2 != null && value1 > value2) {
            ret = true;
        }

        return ret;
    }


    /**
     * 计算统计指标
     *
     * @param sdkStatInfo
     */
    public static SdkIndexStatsDo sdkIndexCompute(SdkIndexStatsDo sdkStatInfo) {

        SdkIndexStatsDo ret = new SdkIndexStatsDo();

        boolean isConfident = false;

        if (AssertUtil.isNotEmpty(sdkStatInfo)) {

            //指标:广告位曝光量，广告位点击量，广告消耗（分）
            Long expCnt = nullToMinDefault(sdkStatInfo.getExpCnt(), 0L);
            Long clickCnt = nullToMinDefault(sdkStatInfo.getClickCnt(), 0L);
            Long adConsume = nullToMinDefault(sdkStatInfo.getAdConsume(), 0L);

            // 判断是否置信
            if (isLarger(expCnt, 50L)
                    && isLarger(clickCnt, 10L)
                    && isLarger(adConsume, 50L)) {
                isConfident = true;
            }

            if (isConfident) {

                // ctr：广告位点击率
                Double ctr = MathUtil.division(clickCnt, expCnt, 6);
                // ecpm: 千次曝光收益
                Double ecpm = MathUtil.division(adConsume * 1000L, expCnt, 6);

                ret.setCtr(ctr);
                ret.setEcpm(ecpm);

            }
        }

        ret.setConfident(isConfident);

        return ret;
    }
}
