package cn.com.duiba.nezha.alg.common.model.activityselectexplore;

import cn.com.duiba.nezha.alg.common.model.activityselectconversionforms.*;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * Created by Administrator on 2019/3/13.
 */
public class ActivitySelectExplore {

    private static final Logger logger = LoggerFactory.getLogger(ActivitySelector.class);

    static class Constant {
        static double MIN_REWARD = 0.1;
        static long DISCOUNT = 2;
        static int MAX_HIS_VAL = 10000;
        static double DECAY = 0.99;  //100次以前的观察，无效
        static int SEARANK_TOPN = 40;
    }

    static class RankInfo {
        double grpm;
        double gexp;
        double gchange;
        double hrpm;
        double hexp;
        double hchange;
        double arpm;
        double aexp;
        double achange;
        double changeScore;

    }

    static class SelectInfo {
        double reward;
        long activityType; //v3.0 未用
        int index;
        long activityId;
        double changeScore;
    }

    static class SelectInfoDetail {
        int index;
        ArrayList<SelectInfo> condi;
    }


    static class MatchInfo {
        double score;
        ActivityInfoModel act;
    }

//actModel 和 和actAd中的活动id与actInfoData 中的活动id保持一致

    public static List<ActivityInfoModel> match(List<ActivityModel> actModel, List<ActivityInfoData> actInfoData,
                                                List<ActivityInfoAdWithType> actAd,
                                                double ProNewCreateACtivityMatch, long exposureThreshold) {

      //v3.5 统计所有有模型参数的活动
        HashMap<Long,Integer> idIndexActModel = new HashMap<Long,Integer>();
        for (int i=0;i<actModel.size();i++) {
            idIndexActModel.put(actModel.get(i).getActivityId(),i);
        }


        int topn = Constant.SEARANK_TOPN;
        List<ActivityInfoModel> result = new ArrayList<ActivityInfoModel>();
        List<ActivityInfoModel> actModelCopy = new ArrayList<ActivityInfoModel>();

        //v3.5 输出用
        //ActivityInfoModelCollect resultCollect = new ActivityInfoModelCollect();
        List<ActivityInfoModel> newCreateActivityCandisList = new ArrayList<ActivityInfoModel>();
        List<ActivityInfoModel> newActivityCandisList = new ArrayList<ActivityInfoModel>();
        List<ActivityInfoModel> oldActivityCandisList = new ArrayList<ActivityInfoModel>();



        Queue<MatchInfo> candis = new PriorityQueue<>(actInfoData.size(), iComparator);
        Queue<MatchInfo> slotCandis = new PriorityQueue<>(actInfoData.size(), iComparator);
        Queue<MatchInfo> appCandis = new PriorityQueue<>(actInfoData.size(), iComparator);
        Queue<MatchInfo> globalCandis = new PriorityQueue<>(actInfoData.size(), iComparator);

        //三种活动 v3.5
        Queue<MatchInfo> newCreateActivityCandis = new PriorityQueue<>(actInfoData.size(), iComparator);
        Queue<MatchInfo> newActivityCandis = new PriorityQueue<>(actInfoData.size(), iComparator);
        Queue<MatchInfo> oldActivityCandis = new PriorityQueue<>(actInfoData.size(), iComparator);



        //排序
        List<ActivityInfoData> actInfoDataCopy =  sortByIdAndSourceData(actInfoData);//广告id大的在前面
        HashMap<Long,ActivityInfoAdWithType> adHashMap = new HashMap<Long,ActivityInfoAdWithType>();

        for(int i = 0;i < actAd.size();++i){
            adHashMap.put(actAd.get(i).getActivityId(),actAd.get(i));
        }

        long sizeActInfoData = actInfoDataCopy.size();

        //判断列表是否相等，不相等抛异常
        HashSet<Long> idset = new HashSet();  //提前 所有选中的活动

        //V3.5
        HashSet<Long> idSetNewCreateActivity = new HashSet();  //
        HashSet<Long> idSetNewActivity = new HashSet();  //
        HashSet<Long> idSetOldActivity = new HashSet();  //



        int limit = topn;  //提前
        int j=0;
        int k=0;
        for (int i = 0;i < sizeActInfoData;++i) {
            try {
                ActivityInfoModel actM = new ActivityInfoModel(); //输出用


               Long activityId=actInfoDataCopy.get(i).getActivityId();

                actM.setActivityId(actInfoDataCopy.get(i).getActivityId());
                actM.setSlotId(actInfoDataCopy.get(i).getSlotId());
                actM.setAppId( actInfoDataCopy.get(i).getAppId());

                //更新历史数据

                //点击
                actM.setHisClick(new Val());
                actM.getHisClick().setGlobalVal(actInfoDataCopy.get(i).getClick().getGlobalVal()); //check
                actM.getHisClick().setAppVal(actInfoDataCopy.get(i).getClick().getAppVal());
                actM.getHisClick().setSlotVal(actInfoDataCopy.get(i).getClick().getSlotVal());

                //消耗
                actM.setHisCost(new Val());
                actM.getHisCost().setGlobalVal(actInfoDataCopy.get(i).getCost().getGlobalVal());
                actM.getHisCost().setAppVal(actInfoDataCopy.get(i).getCost().getAppVal());
                actM.getHisCost().setSlotVal(actInfoDataCopy.get(i).getCost().getSlotVal());

//                System.out.println("actModelCopy.get("+actM.activityId+").hisCost.appVal="+actM.hisCost.appVal);

                //请求
                actM.setHisRequest(new Val());
                actM.getHisRequest().setGlobalVal(actInfoDataCopy.get(i).getRequest().getGlobalVal());
                actM.getHisRequest().setAppVal(actInfoDataCopy.get(i).getRequest().getAppVal());
                actM.getHisRequest().setSlotVal(actInfoDataCopy.get(i).getRequest().getSlotVal());


                //判断是新老活动
                int activityTypeNew=defineActivityType(actM.getHisRequest().slotVal,actInfoDataCopy.get(i).getCreateTime());
                actM.setActivityTypeNew(activityTypeNew);

                actModelCopy.add(actM);

//                System.out.println("actDataCopy.get(i).request.globalVal="+actDataCopy.get(i).request.globalVal);
                //新活动试投



                if (actM.getHisRequest().globalVal < 100) { //全局活动请求数少于100
                    //continue;
                    if (System.currentTimeMillis() - actInfoDataCopy.get(i).getCreateTime() < 60 * 1000 * 60 * 24 * 3) //上架时间小于三天
                    {
                        if (j <5 && Math.random() < ProNewCreateACtivityMatch) { //小于0.01进行试投
                            j +=1;
                            result.add(actM);
                            topn--; //占用一个名额
                            idset.add(actM.getActivityId()) ;
                            idSetNewCreateActivity.add(actM.getActivityId()); //
                            newCreateActivityCandisList.add(actM);


                        }
                    } else if (actInfoDataCopy.size() > limit) { //为什么   !!!这一部分代码删除，会影响创建超过3天但是曝光未超过100的活动！！！

                        if ( k<20 && Math.random() < 0.00001) {  //小于0.00001进行试投  这种是被新创建活动淘汰的，或者新老活动淘汰下来的活动，可以不要 暂时不动
                                    k +=1;
                                    result.add(actM);
                                    topn--;//占用一个名额
                                    idset.add(actM.getActivityId());
                                    idSetNewActivity.add(actM.getActivityId());//
                                    newActivityCandisList.add(actM);
                        }
                    }

                } else {
                    //计算matchscore
                    //添加函数，计算打压系数，打压后为0.5，不打压为1
                    double repressFactor=1.0;
                    if (idIndexActModel.containsKey(activityId)) {
                        int actModelIndex = idIndexActModel.get(activityId);
                        ActivityModel actModelTmp = actModel.get(actModelIndex);
                        int ifOldActivity = actModelTmp.getIfOldActivity();
                        long turnOldAcrtivityTime = actModelTmp.getTurnOldAcrtivityTime();
                        //添加函数 是否打压
                        repressFactor = getRepressgetFactor(actM.getHisRequest().slotVal,ifOldActivity, turnOldAcrtivityTime);
                    }


                    //计算得分

                    double slotScore = WilsonInterval.wilsonCalc((long) actM.getHisClick().slotVal, (long) actM.getHisRequest().slotVal * 3).lowerBound;
                    double globalScore = WilsonInterval.wilsonCalc((long) actM.getHisClick().globalVal, (long) actM.getHisRequest().globalVal * 3).lowerBound;
                    double appScore = WilsonInterval.wilsonCalc((long) actM.getHisClick().appVal, (long) actM.getHisRequest().appVal * 3).lowerBound;


                    //为什么乘以3
                    double coef = 0, matchscore = 0;

                    double sconfidence = Math.min(actM.getHisRequest().slotVal / 100, 1);
                    double aconfidence = Math.min(actM.getHisRequest().appVal / 100, 1);
                    double gconfidence = Math.min(actM.getHisRequest().globalVal / 1000, 1);


                    matchscore = sconfidence * slotScore
                            + (1 - sconfidence) * aconfidence * appScore * 0.9
                            + (1 - sconfidence - (1 - sconfidence) * aconfidence) * globalScore * Math.max(0.5, gconfidence);

                    matchscore=matchscore * repressFactor;

                    double changeScore = 0.0d;
                    ActivityChangeVal  activityChangeValNew= new ActivityChangeVal() ;

                    if (adHashMap.containsKey(actInfoDataCopy.get(i).getActivityId())) {
                        activityChangeValNew= calChangeScoreMergeAbsolute(adHashMap.get(actInfoDataCopy.get(i).getActivityId()).getAdvertsWithType()); //计算广告转化综合得分
                        changeScore = activityChangeValNew.getChangeScoreMerge();
                    }

//                    System.out.println(actM.activityId+" changeScore="+changeScore);
                    actM.setChangeScore(changeScore);
                    actM.setActivityChangeVal(activityChangeValNew);


                    //当slotScore<100的时候，才会启用appScore和globalScore

                    //计算 changeScore

                    MatchInfo info = new MatchInfo();
                    info.act = actM;
                    info.score = matchscore;  //威尔逊点击置信区间得分
                    candis.add(info);

                    //v3.5
                    if (activityTypeNew == 0 ) {
                        newCreateActivityCandis.add(info);
                    } else if (activityTypeNew == 1) {
                        newActivityCandis.add(info);

                       }  else {
                                if (sconfidence > 0.99 || actM.getHisClick().slotVal > 5) { //广告位请求数大于99 或点击大于5
                                    MatchInfo info2 = new MatchInfo();
                                    info2.act = actM;
                                    //分数是消耗除以请求数
                                    info2.score = actM.getHisRequest().slotVal > 0 ? actM.getHisCost().slotVal / actM.getHisRequest().slotVal : 0;

                                    slotCandis.add(info2);
                                    oldActivityCandis.add (info2);
                                }

                                if (aconfidence > 0.99 || actM.getHisClick().appVal > 5) { //app请求数大于99 或点击大于5  //bug 应该是appVal>5
                                    MatchInfo info3 = new MatchInfo();
                                    info3.act = actM;
                                    //分数是消耗除以请求数
                                    info3.score = actM.getHisRequest().appVal > 0 ? actM.getHisCost().appVal / actM.getHisRequest().appVal : 0;
                                    appCandis.add(info3);

                                }

                         }
                }
            } catch (Exception e) {
    //                logger.error("error, act:{}", JSON.toJSONString(actM));
                    logger.error(e.getMessage(), e);
    //                System.out.println(e.getMessage());
                }
        }


      //海选topN个

        // 投过的老活动 保留15个
        int size1 = slotCandis.size();
        for (int i = 0; i < 15 && i < size1; i++) {
            ActivityInfoModel act =  slotCandis.poll().act;
            if (idset.contains(act.getActivityId()))
                continue;
            result.add(act);   //未判断去重 可能重复
            oldActivityCandisList.add(act);
            idset.add(act.getActivityId());
            topn-- ;
        }

        //新创建活动 保留5个
        int sizeIdNC1=idSetNewCreateActivity.size();
        int sizeNC1=newCreateActivityCandis.size();

        if (sizeIdNC1<5 && sizeNC1>0  ) {
            for (int i=0;(i< 5- sizeIdNC1) && i < sizeNC1;i++) {
                ActivityInfoModel act =  newCreateActivityCandis.poll().act;
                if (idset.contains(act.getActivityId()))
                    continue;
                result.add(act);
                newCreateActivityCandisList.add(act);
                idset.add(act.getActivityId());
                topn-- ;
            }
        }

        //新活动 20个
        int sizeIdN1= idSetNewActivity.size();
        int sizeN1=newActivityCandis.size();

        if (sizeIdN1<20 && sizeN1>0 ) {
            for (int i = 0; (i < 20 - sizeIdN1) && i < sizeN1; i++) {
                ActivityInfoModel act = newActivityCandis.poll().act;
                if (idset.contains(act.getActivityId()))
                    continue;
                result.add(act);
                newActivityCandisList.add(act);
                idset.add(act.getActivityId());
                topn--;
            }
        }



        int size = candis.size();
        int resultSize=result.size() ;

        //for (int i = 0; i < topn && i < size; i++) {
        for (int i = 0; resultSize < limit && i < size; i++) {
            ActivityInfoModel act =  candis.poll().act;
            if(idset.contains(act.getActivityId()))
                continue;
            result.add(act);
            idset.add(act.getActivityId());   //凑齐topn个活动
            resultSize = result.size() ;
            topn-- ;

            //3.5
            int activityTypeNew=act.getActivityTypeNew();
            if (activityTypeNew==0){
                newCreateActivityCandisList.add(act);
            } else if (activityTypeNew==1){
                newActivityCandisList.add(act);
            } else {
                oldActivityCandisList.add(act);
            }

        }


        //未凑齐 补充
        if (result.size() < limit) {
            int count = topn;
            for (int i = 0;i < sizeActInfoData;++i){

                if(idset.contains(actInfoDataCopy.get(i).getActivityId()))
                    continue;
                idset.add(actInfoDataCopy.get(i).getActivityId());
                actModelCopy.get(i).getHisClick().globalVal = actInfoDataCopy.get(i).getClick().globalVal;
                actModelCopy.get(i).getHisClick().appVal = actInfoDataCopy.get(i).getClick().appVal;
                actModelCopy.get(i).getHisClick().slotVal = actInfoDataCopy.get(i).getClick().slotVal;

                actModelCopy.get(i).getHisCost().globalVal = actInfoDataCopy.get(i).getCost().globalVal;
                actModelCopy.get(i).getHisCost().appVal = actInfoDataCopy.get(i).getCost().appVal;
                actModelCopy.get(i).getHisCost().slotVal = actInfoDataCopy.get(i).getCost().slotVal;

                actModelCopy.get(i).getHisRequest().globalVal = actInfoDataCopy.get(i).getRequest().globalVal;
                actModelCopy.get(i).getHisRequest().appVal = actInfoDataCopy.get(i).getRequest().appVal;
                actModelCopy.get(i).getHisRequest().slotVal = actInfoDataCopy.get(i).getRequest().slotVal;

                result.add( actModelCopy.get(i));
                count++;

                int activityTypeNew=defineActivityType(actModelCopy.get(i).getHisRequest().slotVal,actInfoDataCopy.get(i).getCreateTime());
                if (activityTypeNew==0){
                    newCreateActivityCandisList.add(actModelCopy.get(i));
                } else if (activityTypeNew==1){
                    newActivityCandisList.add(actModelCopy.get(i));
                } else {
                    oldActivityCandisList.add(actModelCopy.get(i));
                }


                if(count >= topn)
                    break;
            }
        }

        return result;
    }


//包装3层
    //actModelCollect 和 actDataCollect 里面每项数据的活动id保持一致
// list中按照 索引及对应对象： 0： newCreateActivity ， 1：newActivityActivity， 2：oldActivityActivity， 3：allMatchActivity 顺序

    //actModel 和 actData 中的活动id顺序保持一致

    public static SelectActivityResult select (List<ActivityModel> actModel,List<ActivityData> actData,
                                               double gama, double ProNewCreateACtivitySelect,
                                               double ProNewACtivitySelect, double ProOldACtivitySelect ) {

        SelectActivityResult result= new SelectActivityResult();


        //1.判断列表长度，不一致抛异常
        if(actModel.size() == 0|| actData.size() ==0){
            System.out.println("error 1! ");
            return null;
        }
        if (actModel.size() != actData.size()){
            result.setActivityModel(actModel.get(0));
            result.setSameCostActivitiesInfoList(null);
            System.out.println("error 2! ");
            return result; //todo 抛异常
        }
        List<ActivityModel> actModelCopy =  sortByIdAndSourceModelBack(actModel);  //广告id倒排
        List<ActivityData> actDataCopy =  sortByIdAndSourceDataBack(actData);



        //活动 id 对不上返回空
        for(int i = 0; i< actModelCopy.size();++i) {
            long activityIdMode = actModelCopy.get(i).getActivityId();
            long activityIdData = actDataCopy.get(i).getActivityId();
            if (activityIdMode != activityIdData) {
                result.setActivityModel(actModel.get(0));
                result.setSameCostActivitiesInfoList(null);
                System.out.println("error 3! ");
                return result; // todo 抛异常
            }
            actModelCopy.get(i).setChangeScore(actDataCopy.get(i).getChangeScore());
        }

        //System.out.println("actDataCopy2 size2= " + actDataCopy.size());

        //分组
        List<ActivityModel> newCreateActivityModel =new ArrayList<>();
        List<ActivityModel> newActivityModel=new ArrayList<>();
        List<ActivityModel> oldActivityModel=new ArrayList<>();


        List<ActivityData> newCreateActivityData =new ArrayList<>();
        List<ActivityData> newActivityData=new ArrayList<>();
        List<ActivityData> oldActivityData=new ArrayList<>();

        int j=0;
        for (int i=0; i< actDataCopy.size() ; i ++) {

            ActivityModel activityModel=actModelCopy.get(i);
            ActivityData activityData=actDataCopy.get(i);



            if ( activityData.getActivityTypeNew()==0  ) {
                newCreateActivityData.add(activityData);
                newCreateActivityModel.add(activityModel);

            } else if (activityData.getActivityTypeNew()==1) {
                newActivityData.add(activityData);
                newActivityModel.add(activityModel);

            } else if (activityData.getActivityTypeNew()==2 ) {
                oldActivityData.add(activityData);
                oldActivityModel.add(activityModel);
            } else {
                j +=1;
                continue;
            }
        }

        if ( j==actDataCopy.size()) {
            System.out.println("input error activityTypeNew !");
            return null;
        }

        //System.out.println("newCreateActivityData.size()= " + newCreateActivityData.size());
        //System.out.println("newActivityData.size()= " + newActivityData.size());
        //System.out.println("oldActivityModel.size()= " + oldActivityModel.size());


        HashMap<Integer,List<ActivityModel>>  mapActivityMode=new HashMap<>();
        HashMap<Integer,List<ActivityData>>  mapActivityData=new HashMap<>();

        if (newCreateActivityData.size()>0 ) {
            mapActivityData.put(0,newCreateActivityData);
            mapActivityMode.put(0,newCreateActivityModel);
        }

        if (newActivityData.size()>0 ) {
            mapActivityData.put(1,newActivityData);
            mapActivityMode.put(1,newActivityModel);
        }

        if (oldActivityData.size()>0 ) {
            mapActivityData.put(2,oldActivityData);
            mapActivityMode.put(2,oldActivityModel);
        }



        int mapKey = 2;
        double rand = Math.random();

        if (rand < ProNewCreateACtivitySelect) {
            mapKey = 0;
        } else if (rand >= ProNewCreateACtivitySelect && rand < (ProNewCreateACtivitySelect+ProNewACtivitySelect)) {
            mapKey = 1;
        }

        //System.out.println("mapKey= " + mapKey);

        List<Integer> keyList=new ArrayList<>(mapActivityData.keySet());

        //System.out.println("mapActivityData.keySet()  " + mapActivityData.keySet());
       // System.out.println("keyList size " + keyList.size());

        if ( !mapActivityData.containsKey(mapKey) ) {
            int index = (int) (Math.random() * keyList.size());
            mapKey =keyList.get(index);
        }

        //System.out.println("mapKey2= " + mapKey);

        List<ActivityModel> actModelListNew = mapActivityMode.get(mapKey);
        List<ActivityData> ActivityDataListNew = mapActivityData.get(mapKey);


        //优选

            SelectActivityResult result1 = selectDetail(actModelListNew, ActivityDataListNew, gama);

            result.setActivityModel(result1.getActivityModel());
            result.setSameCostActivitiesInfoList(result1.getSameCostActivitiesInfoList());



        return result;
    }


    //返回列表中的空子列表索引

    public static List<Integer> getUseListIndex (List<List<ActivityModel>> actModelList,List<List<ActivityData>> actDataList) {

        List<Integer> ret = new ArrayList<Integer>();

        for (int i = 0; i < actModelList.size(); i++) {

            if (actModelList.size() > 0 || actDataList.size() > 0) {
                ret.add(i);
            }
        }
        return ret;
    }



    //优选
    public static SelectActivityResult selectDetail(List<ActivityModel> actModel, List<ActivityData> actData, double gama) {

        SelectActivityResult  selectActivityResult=new SelectActivityResult();

        //1.判断列表长度，不一致抛异常
        if(actModel.size() == 0|| actData.size() ==0){
            System.out.println(" list is empty !");
            return null;
        }
        if (actModel.size() != actData.size()){
            selectActivityResult.setActivityModel(actModel.get(0));
            selectActivityResult.setSameCostActivitiesInfoList(null);
            System.out.println(" list size is not same !");
            return null; //todo 抛异常
        }


        List<ActivityModel> actModelCopy =  sortByIdAndSourceModelBack(actModel);  //广告id倒排
        List<ActivityData> actDataCopy =  sortByIdAndSourceDataBack(actData);

        //活动 id 对不上返回空
        for(int i = 0; i< actModelCopy.size();++i) {
            long activityIdMode = actModelCopy.get(i).getActivityId();
            long activityIdData = actDataCopy.get(i).getActivityId();
            if (activityIdMode != activityIdData) {
                selectActivityResult.setActivityModel(actModel.get(0));
                selectActivityResult.setSameCostActivitiesInfoList(null);
                System.out.println(" list element is different !");
                return null; // todo 抛异常
            }
            actModelCopy.get(i).setChangeScore(actDataCopy.get(i).getChangeScore());
        }

        //2.排序

        //1、init
        ArrayList<Double> rewards = new ArrayList<>();
        ArrayList<Double> counts = new ArrayList<>();
        ArrayList<Double> alphas = new ArrayList<>();
        ArrayList<Double> betas = new ArrayList<>();
        ArrayList<Double> changeScores = new ArrayList<>();
        ArrayList<Long> activityIds = new ArrayList<>();
        ArrayList<Long> activityTypes = new ArrayList<>();

        List<ActivityModel> candiList = new ArrayList<>();

        double decay = Constant.DECAY;

        int size = 0;

        HashMap<Long, RankInfo> mMap = new HashMap();
        double maxG = Constant.MIN_REWARD, maxH = Constant.MIN_REWARD, maxA = Constant.MIN_REWARD;
        double maxGchange = Constant.MIN_REWARD, maxHchange = Constant.MIN_REWARD, maxAchange = Constant.MIN_REWARD;
        ActivityModel result = null;

        try {

            //2、match

            //3、rank
            //3.1 get info
            for (int i = 0;i<actDataCopy.size();++i) {
                //get global data Click
                RankInfo info = mMap.containsKey(actDataCopy.get(i).getActivityId()) ? mMap.get(actDataCopy.get(i).getActivityId()) : new RankInfo();
                double grpm = actDataCopy.get(i).getHisRequest().globalVal > 0 ? actDataCopy.get(i).getHisCost().globalVal / actDataCopy.get(i).getHisRequest().globalVal : 0;

                info.grpm = grpm;
                info.gexp = actDataCopy.get(i).getHisRequest().globalVal;
                maxG = Math.max(grpm, maxG);


                //get app data Cost
                double arpm = actDataCopy.get(i).getHisRequest().appVal > 0 ? actData.get(i).getHisCost().appVal / actData.get(i).getHisRequest().appVal : 0;

                info.arpm = arpm;
                info.aexp = actDataCopy.get(i).getHisRequest().appVal;
                if (info.hexp > 50) {
                    maxA = Math.max(arpm, maxA);

                }


                //get slot data Cost
                double hrpm = actDataCopy.get(i).getHisRequest().slotVal > 0 ? actData.get(i).getHisCost().slotVal / actData.get(i).getHisRequest().slotVal : 0;

                info.hrpm = hrpm;
                info.hexp = actDataCopy.get(i).getHisRequest().slotVal;



                //System.out.println(hrpm+"\t"+maxH);

                mMap.put(actDataCopy.get(i).getActivityId(), info);
            }

            for (int i = 0;i<actDataCopy.size();++i) {

                double reward = Constant.MIN_REWARD;
                double sconfidence = Math.min(actDataCopy.get(i).getHisRequest().slotVal / 60, 1);
                double aconfidence = Math.min(actDataCopy.get(i).getHisRequest().appVal / 60, 1);

                reward = sconfidence * normlize(mMap.get(actDataCopy.get(i).getActivityId()).hrpm * 0.8, maxH, 0.8) +
                        (1 - sconfidence) * aconfidence * normlize(mMap.get(actDataCopy.get(i).getActivityId()).arpm * 0.7, maxA, 0.7) +
                        (1 - sconfidence - (1 - sconfidence) * aconfidence) * normlize(mMap.get(actDataCopy.get(i).getActivityId()).grpm * 0.5, maxG, 0.6);

                //System.out.println(actDataCopy.get(i)+" reward="+reward);
                reward = reward * reward;

                reward = Math.max(reward, Constant.MIN_REWARD);


                // v3.5  计算打压系数 从老活动降下来的 竞争力打8折
                //更新是否达到老活动条件及达到时间  v3.5
                 double slotRequest=actDataCopy.get(i).getHisRequest().slotVal;
                 int ifOldActivity=actModelCopy.get(i).getIfOldActivity();
                 long  turnOldAcrtivityTime=actModelCopy.get(i).getTurnOldAcrtivityTime();

                stateNewAndRepressgetFactor  newState= updataOldStateAndPressFactor(slotRequest,ifOldActivity,turnOldAcrtivityTime);
                double repressgetFactor=newState.repressgetFactor;

                actModelCopy.get(i).setIfOldActivity(newState.ifOldActivity);
                actModelCopy.get(i).setTurnOldAcrtivityTime(newState.turnOldAcrtivityTime);
                reward = reward * repressgetFactor;


                actModelCopy.get(i).setReward(actModelCopy.get(i).getReward() * decay + reward);
                actModelCopy.get(i).setCount(actModelCopy.get(i).getCount() * decay + 1.0);
                actModelCopy.get(i).setAlpha(1.5 + actModelCopy.get(i).getReward());
                actModelCopy.get(i).setBeta( 2.0 + (actModelCopy.get(i).getCount() - actModelCopy.get(i).getReward()));




                rewards.add(actModelCopy.get(i).getReward());
                counts.add(actModelCopy.get(i).getCount());
                alphas.add(actModelCopy.get(i).getAlpha());
                betas.add(actModelCopy.get(i).getBeta());
                activityTypes.add(actModelCopy.get(i).getActivityType());  //旧 3.0
                activityIds.add(actModelCopy.get(i).getActivityId());
                changeScores.add(actModelCopy.get(i).getChangeScore());

                candiList.add(actModelCopy.get(i));
            }

            //4、select

            int numMachines = candiList.size();

            SelectInfoDetail selectInfoDetail = selectMachineWithChangeScore(alphas, betas,activityTypes, activityIds,changeScores,numMachines,gama);

            int selectedActivityIndex = selectInfoDetail.index;
            result = candiList.get(selectedActivityIndex);  //筛选出来的活动及对应的模型参数


            //消耗分相近的活动信息
            ArrayList<SelectInfo> sameCostcondi = selectInfoDetail.condi;
            Double selectedActivityChangeScore=result.getChangeScore();
            int sameCostActivityCnt=sameCostcondi.size();

            //System.out.println("selectedActivityIndex: " +selectedActivityIndex);
            //System.out.println("selectedActivityChangeScore: " +selectedActivityChangeScore);

            List<SameCostActivitiesInfo> sameCostActivitiesInfoList = new ArrayList<>();

            for (SelectInfo  selectInfo:sameCostcondi){

                SameCostActivitiesInfo sameCostActivitiesInfo=new SameCostActivitiesInfo();

                Long  activityId=selectInfo.activityId;
                Long activityType=selectInfo.activityType;

                int ifSelected=0;
                if (selectInfo.index==selectedActivityIndex){
                    ifSelected=1;
                }

                int index=selectInfo.index;

                Double mabReward=selectInfo.reward;
                Double changeScore=selectInfo.changeScore;

                //计算与最优的差异
                Double diffChangeScore=selectInfo.changeScore-selectedActivityChangeScore;

                //封装
                sameCostActivitiesInfo.setActivityId(activityId);
                sameCostActivitiesInfo.setSameActivityCnt(sameCostActivityCnt);
                sameCostActivitiesInfo.setActivityType(activityType);
                sameCostActivitiesInfo.setIfSelected(ifSelected);
                sameCostActivitiesInfo.setMabReward(mabReward);   //带转化筛选时重新计算了reward，与前面的reward计算不一致
                sameCostActivitiesInfo.setChangeScore(changeScore);
                sameCostActivitiesInfo.setIndex(index);
                sameCostActivitiesInfo.setDiffChangeScore(diffChangeScore);
                sameCostActivitiesInfoList.add(sameCostActivitiesInfo);
                //System.out.println("sameCostInfo: " +sameCostInfo);
            }


            //result = candiList.get(selectMachineWithChangeScore(alphas, betas,activityTypes, activityIds,changeScores,numMachines,gama));


            selectActivityResult.setActivityModel(result);
            selectActivityResult.setSameCostActivitiesInfoList(sameCostActivitiesInfoList);

            mMap.clear();

            //System.out.println(result.activityId);
            return selectActivityResult;
            //return result;
        }catch (Exception e)
        {
            logger.error(e.getMessage(), e);
            logger.error("error, size:{},candi:{},list:{},", size, JSON.toJSONString(candiList), JSON.toJSONString(result));
        }

        return null;
    }




    public static double normlize(double val, double max, double limit) {
        double norm = Math.min(val * limit / max, limit);
        return norm;
    }




    public static Comparator<MatchInfo> iComparator = new Comparator<MatchInfo>() {

        @Override
        public int compare(MatchInfo c1, MatchInfo c2) {
            return (int) (c2.score - c1.score >= 0 ? 1 : -1); //按score大小排序
        }
    };


    private static List<ActivityInfoData> sortByIdAndSourceData(List<ActivityInfoData> acts){

        List<ActivityInfoData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityInfoData>() {
            public int compare(ActivityInfoData act1, ActivityInfoData act2) {
                if(act1.getActivityId() > act2.getActivityId()) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }


    //判断是新活动还是老活动
    //0：新创建活动，1：新活动；2:老活动
    private static int  defineActivityType(double slotRequestCnt, long activityCreateTime) {

        int ret = 1;
       if (slotRequestCnt>=100) {
           ret = 2;
       }
       else if (System.currentTimeMillis() - activityCreateTime < 60 * 1000 * 60 * 24 * 3) {
           ret = 0;
       }

       return ret;
    }


   //判断新活动打压系数
  //1 不打压；0.5打压
   private static double  getRepressgetFactor (double slotRequestCnt,int ifOldActivity, long turnOldAcrtivityTime) {
        double ret=1;
       long diffTime = System.currentTimeMillis() - turnOldAcrtivityTime;

       if (ifOldActivity==1 && slotRequestCnt<100 && diffTime < 60 * 1000 * 60 * 24 * 30){
           ret=0.5; //打压
       }

       return ret;
   }



   //更新老活动状态
   static class stateNewAndRepressgetFactor {
       int  ifOldActivity;
       long turnOldAcrtivityTime;
       double repressgetFactor;
   }


    private static stateNewAndRepressgetFactor  updataOldStateAndPressFactor (double slotRequestCnt,int ifOldActivity, long turnOldAcrtivityTime) {

        stateNewAndRepressgetFactor ret = new stateNewAndRepressgetFactor();

        ret.repressgetFactor=1.0;

        long timeDiff= System.currentTimeMillis() - turnOldAcrtivityTime;

        if ( slotRequestCnt>=100 ) {
            ret.ifOldActivity = 1;
            ret.turnOldAcrtivityTime = System.currentTimeMillis();
            //System.out.println("SystemCurrentTimeMillis()= " + System.currentTimeMillis());

        } else if (slotRequestCnt< 100) {

               ret.ifOldActivity = 0;
               ret.turnOldAcrtivityTime = System.currentTimeMillis();

               if (ifOldActivity ==1 && timeDiff < 60 * 1000 * 60 * 24 * 30 ) {
                   ret.ifOldActivity = 1;
                   ret.turnOldAcrtivityTime = turnOldAcrtivityTime;
                   ret.repressgetFactor=0.8;
               }
        }
        return ret;
    }



    //卡包分版本
    private static SelectInfoDetail selectMachineWithChangeScore(List<Double> alphas, List<Double> betas,List<Long> activityTypes,List<Long> activityIds,List<Double> changeScores, int numMachines,double gama) {
        int selectMachine = 0;
        ArrayList<SelectInfo> sinfos = new  ArrayList<SelectInfo>();
        for (int i = 0; i < numMachines; i++) {
            double theta = BetaDistribution.BetaDist(alphas.get(i), betas.get(i));
            SelectInfo sinfo = new SelectInfo();
//            System.out.println(activityIds.get(i)+"= "+theta);
            sinfo.reward = theta;
            sinfo.activityType = activityTypes.get(i);
            sinfo.index = i;
            sinfo.activityId = activityIds.get(i);
            sinfo.changeScore = changeScores.get(i);
            sinfos.add(sinfo);
        }

        Collections.sort(sinfos, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.reward > sinfo2.reward) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });


        ArrayList<SelectInfo> condi = new ArrayList<SelectInfo>();

        for(int i = 0;i < sinfos.size();++i) {
            if(sinfos.get(0).reward - sinfos.get(i).reward <= gama) { //生成消耗分接近的候选集
                System.out.println("condi "+i+" activityId="+sinfos.get(i).activityId+" theta="+sinfos.get(i).reward+" "+" activityType="+sinfos.get(i).activityType+" changeScore="+changeScores.get(i));
                condi.add(sinfos.get(i));
            }
        }
        Collections.sort(condi, new Comparator<SelectInfo>() {
            public int compare(SelectInfo sinfo1, SelectInfo sinfo2) {
                if(sinfo1.changeScore > sinfo2.changeScore) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
//        System.out.println(condi.get(0).activityId+"="+condi.get(0).changeScore);
//        System.out.println(condi.get(1).activityId+"="+condi.get(1).changeScore);
        selectMachine = condi.get(0).index; //选取一定范围内转化最高的

        for(int i = 0; i < condi.size();++i) {
            if(condi.get(i).activityType != 21){
                selectMachine = condi.get(i).index; //选取消耗分最大的非卡包
                break;
            }
        }

//        System.out.println("sinfos="+sinfos.get(0).activityId);
//        System.out.println("sinfos="+sinfos.get(1).activityId);
//        return  sinfos.get(0).index;
//        System.out.println("selectMachine="+selectMachine);

        //打印消耗分相近的活动的所有信息
        SelectInfoDetail selectInfoDetail=new SelectInfoDetail();
        selectInfoDetail.condi=condi;  //消耗分相近的每个活动信息
        selectInfoDetail.index=selectMachine;  //最优活动索引

        return selectInfoDetail;
        //return selectMachine;

    }





    //融合表单和非表单类广告，用绝对值的cvr分数
    public static ActivityChangeVal calChangeScoreMergeAbsolute(List<AdvertWithType> ads) {

        double changeScoreMerge = 0.0;

        double changeScoreForms = 0.0;  //该活动下
        double changeScoreNotForms = 0.0;


        double changeScoreFormsGlobal = 0.0;  //全局
        double changeScoreNotFormsGlobal = 0.0;

        double sumClick = 0.0;
        double sumEffectPV = 0.0;

        double sumClickGlobal = 0.0;
        double sumEffectPVGlobal = 0.0;

        //该活动下表单类广告
        double sumClickForms = 0.0;
        double sumEffectPVForms = 0.0;

        //该活动下非表单类广告
        double sumClickNotForms = 0.0;
        double sumEffectPVNotForms = 0.0;


        //全局表单类广告
        double sumGlobalClickForms = 0.0;
        double sumGlobalEffectPVForms = 0.0;

        //全局非表单类广告
        double sumGlobalClickNotForms = 0.0;
        double sumGlobalEffectPVNotForms = 0.0;

        Long formsAdvertCnt=0L; //表单类广告个数
        Long notFormsAdvertCnt=0L; //非表单类广告个数


        for (AdvertWithType ad:ads){
             if (ad.getIfForms()==1){
                sumClickForms +=ad.getClick();
                sumEffectPVForms +=ad.getEffectPV();

                sumGlobalClickForms += ad.getGlobalClick();
                sumGlobalEffectPVForms += ad.getGlobalEffectPV();
                formsAdvertCnt += 1L;

             }
             else {
                sumClickNotForms +=ad.getClick();
                sumEffectPVNotForms +=ad.getEffectPV();

                sumGlobalClickNotForms += ad.getGlobalClick();
                sumGlobalEffectPVNotForms  += ad.getGlobalEffectPV();
                notFormsAdvertCnt += 1L;

             }

            sumClick += ad.getClick();
            sumEffectPV += ad.getEffectPV();

            sumClickGlobal += ad.getGlobalClick();
            sumEffectPVGlobal += ad.getGlobalEffectPV();
        }

        //直接用总转化除以总点击

        changeScoreForms =sumClickForms > 0 ? sumEffectPVForms/sumClickForms: 0 ;
        changeScoreNotForms = sumClickNotForms > 0 ? sumEffectPVNotForms/sumClickNotForms: 0 ;


        changeScoreFormsGlobal = sumGlobalClickForms >0 ? sumGlobalEffectPVForms / sumGlobalClickForms : 0;
        changeScoreNotFormsGlobal = sumGlobalClickNotForms >0 ? sumGlobalEffectPVNotForms / sumGlobalClickNotForms :0 ;

        double effctFormsWeight = Math.min(sumEffectPVForms/3.0,1.0);
        double globalEffectFormsWeight= Math.min(sumGlobalEffectPVForms/100.0,1.0);

        double  effctNotFormsWeight=Math.min(sumEffectPVNotForms/30.0,1.0);
        double globalEffectNotFormsWeight= Math.min(sumGlobalEffectPVNotForms/100.0,1.0);

        double rand = Math.random();

//本广告位表单类和全局表单类数据加权  对表单类点击和转化做限制  不考虑非表单数据
        if ( sumEffectPVForms >=1 ) {
            changeScoreMerge = changeScoreForms;

        } else if ( 0 <= sumClickForms && sumClickForms < 100  && changeScoreFormsGlobal >0 ) {
            int w1 = (int) (sumClickForms / 100.0 / 0.2);
            int w2 = 5 - w1;
            changeScoreMerge = 0.01 * w2 * changeScoreFormsGlobal;

        } else if (sumClickForms >= 100 && changeScoreFormsGlobal >0 ) {
            changeScoreMerge = changeScoreFormsGlobal * 1.0 / sumClickForms;

        } else if ( changeScoreNotForms >0 ) {
            changeScoreMerge = changeScoreNotForms * 1.0 / 10000;

        }  else if (rand <= 0.001 ) {
            changeScoreMerge = Math.random();
        }

        //输出 转化得分明细
        ActivityChangeVal  activityChangeVal= new ActivityChangeVal() ;

        activityChangeVal.setSumClickForms(sumClickForms);
        activityChangeVal.setSumEffectPVForms(sumEffectPVForms);

        activityChangeVal.setSumClickNotForms(sumClickNotForms);
        activityChangeVal.setSumEffectPVNotForms(sumEffectPVNotForms);

        activityChangeVal.setSumGlobalClickForms(sumGlobalClickForms);
        activityChangeVal.setSumGlobalEffectPVForms(sumGlobalEffectPVForms);

        activityChangeVal.setSumGlobalClickNotForms(sumGlobalClickNotForms);
        activityChangeVal.setSumGlobalEffectPVNotForms(sumGlobalEffectPVNotForms);

        activityChangeVal.setChangeScoreForms(changeScoreForms);
        activityChangeVal.setChangeScoreNotForms(changeScoreNotForms);

        activityChangeVal.setChangeScoreFormsGlobal(changeScoreFormsGlobal);
        activityChangeVal.setChangeScoreNotFormsGlobal(changeScoreNotFormsGlobal);

        activityChangeVal.setFormsAdvertCnt(formsAdvertCnt);
        activityChangeVal.setNotFormsAdvertCnt(notFormsAdvertCnt);
        activityChangeVal.setChangeScoreMerge(changeScoreMerge);

        //结果输出
        return activityChangeVal ;
    }



    private static List<ActivityModel> sortByIdAndSourceModelBack(List<ActivityModel> acts){
        List<ActivityModel> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityModel>() {
            public int compare(ActivityModel act1, ActivityModel act2) {
                if(act1.getActivityId() > act2.getActivityId()) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;

    }

    private static List<ActivityData> sortByIdAndSourceDataBack(List<ActivityData> acts){

        List<ActivityData> actCopy = acts;
        Collections.sort(actCopy, new Comparator<ActivityData>() {
            public int compare(ActivityData act1, ActivityData act2) {
                if(act1.getActivityId() > act2.getActivityId()) {
                    return -1;
                }
                else {
                    return 1;

                }
            }
        });
        return actCopy;
    }



}
