package cn.com.duiba.nezha.alg.common.model.pacing;

import java.util.Objects;

public class AdvertOrientInfo {

    Long advertId;
    Long orientId;
    Double costConvertBias;
    Double cost;

    public AdvertOrientInfo() {
    }

    public AdvertOrientInfo(Long advertId, Long orientId) {
        this.advertId = advertId;
        this.orientId = orientId;
    }

    public AdvertOrientInfo(Long advertId, Long orientId, Double costConvertBias, Double cost) {
        this.advertId = advertId;
        this.orientId = orientId;
        this.costConvertBias = costConvertBias;
        this.cost = cost;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientId() {
        return orientId;
    }

    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    public Double getCostConvertBias() {
        return costConvertBias;
    }

    public void setCostConvertBias(Double costConvertBias) {
        this.costConvertBias = costConvertBias;
    }

    public Double getCost() {
        return cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdvertOrientInfo that = (AdvertOrientInfo) o;
        return Objects.equals(advertId, that.advertId) &&
                Objects.equals(orientId, that.orientId);
    }

    @Override
    public String toString() {
        return "AdvertOrientInfo{" +
                "advertId=" + advertId +
                ", orientId=" + orientId +
                '}';
    }

    @Override
    public int hashCode() {
        return Objects.hash(advertId, orientId);
    }
}
