package cn.com.duiba.nezha.alg.common.model.pacing;

import java.io.Serializable;
import java.util.List;

public class OrientInfo {

    Long advertId;
    Long orientId;
    Long appId;
    Double appOrientCvrDay;

    Double cost20d;      //20天消耗
    List<Double> cvrSet;           // 如：[0.1522,0.2324,0.1156] 对应cvrType顺序0 1 2 3 4
    List<Double> biasSet;         //偏差   如：[0.8555",1.5786,1.1132]  对应cvrType顺序0 1 2 3 4

    Type type;             //流量描述符
    boolean isManagered; //是否开启托管
    Integer manageType;//系统托管方式 //自动模式：2  优投模式：3
    Integer chargeType;  //计费方式
    Long target = 0l;       //目标成本
    Long fee = 0l; //出价
    Double factor;                //ocpc调价因子
    Double orientCostG7d = 0.0;             //配置全局7天消耗
    Double orientCostG1d = 0.0;             //配置全局1天消耗
    Double orientConvertG1d = 0.0;               //配置全局转化量
    Double slotAdvertCost;               //广告位+广告粒度消耗
    Double slotAdvertConvert;               //广告位+广告粒度转化量
    Double slotOrientationCost;               //广告位+配置粒度消耗
    Double slotOrientationConvert;               //广告位+配置粒度转化量
    Double appOrientationCost;               //媒体+配置粒度消耗
    Double appOrientationConvert;               //媒体+配置粒度转化量

    Long importantAppAfee;   //重点媒体转化出价  默认null
    Integer cvrType;   //cvr类型   默认为前端cvr
    Integer releaseTarget;  //投放目标  1：消耗优先  2：成本优先  3：均衡   默认为均衡模式

    Boolean fuseWhite;//是否熔断白名单  true：不熔断

    AutoMatchInfo autoMatchInfo;
    int quailityLevel = 0; //智能匹配黑名单 0 = 默认 1,2,3=黑名单 8 = 白名单  16=熔断



    HelpMeasureResult helpMeasureResult;


    public class Type implements Serializable {
        Integer chargeType;   //1=cpc 2=ocpc
        Integer pid;          //000 = 默认  010 = 娃娃机  100 = 智能匹配
        Integer packageType;    //默认 = 0000   用户点击感兴趣转化不感兴趣 1001

        public void setChargeType(Integer chargeType) {
            this.chargeType = chargeType;
        }

        public void setPackageType(Integer packageType) {
            this.packageType = packageType;
        }

        public void setPid(Integer pid) {
            this.pid = pid;
        }
    }


    public OrientInfo() {
    }

    public OrientInfo(Long advertId, Long orientId, Long appId, Double appOrientCvrDay, Double cost20d, List<Double> cvrSet, List<Double> biasSet, Type type, boolean isManagered, Integer manageType, Integer chargeType, Long target, Long fee, Double factor, Double orientCostG7d, Double orientCostG1d, Double orientConvertG1d, Double slotAdvertCost, Double slotAdvertConvert, Double slotOrientationCost, Double slotOrientationConvert, Double appOrientationCost, Double appOrientationConvert, Long importantAppAfee, Integer cvrType, Integer releaseTarget, Boolean fuseWhite, AutoMatchInfo autoMatchInfo, int quailityLevel,HelpMeasureResult helpMeasureResult) {
        this.advertId = advertId;
        this.orientId = orientId;
        this.appId = appId;
        this.appOrientCvrDay = appOrientCvrDay;
        this.cost20d = cost20d;
        this.cvrSet = cvrSet;
        this.biasSet = biasSet;
        this.type = type;
        this.isManagered = isManagered;
        this.manageType = manageType;
        this.chargeType = chargeType;
        this.target = target;
        this.fee = fee;
        this.factor = factor;
        this.orientCostG7d = orientCostG7d;
        this.orientCostG1d = orientCostG1d;
        this.orientConvertG1d = orientConvertG1d;
        this.slotAdvertCost = slotAdvertCost;
        this.slotAdvertConvert = slotAdvertConvert;
        this.slotOrientationCost = slotOrientationCost;
        this.slotOrientationConvert = slotOrientationConvert;
        this.appOrientationCost = appOrientationCost;
        this.appOrientationConvert = appOrientationConvert;
        this.importantAppAfee = importantAppAfee;
        this.cvrType = cvrType;
        this.releaseTarget = releaseTarget;
        this.fuseWhite = fuseWhite;
        this.autoMatchInfo = autoMatchInfo;
        this.quailityLevel = quailityLevel;
        this.helpMeasureResult = helpMeasureResult;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getOrientId() {
        return orientId;
    }

    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Double getAppOrientCvrDay() {
        return appOrientCvrDay;
    }

    public void setAppOrientCvrDay(Double appOrientCvrDay) {
        this.appOrientCvrDay = appOrientCvrDay;
    }

    public Double getCost20d() {
        return cost20d;
    }

    public void setCost20d(Double cost20d) {
        this.cost20d = cost20d;
    }

    public List<Double> getCvrSet() {
        return cvrSet;
    }

    public void setCvrSet(List<Double> cvrSet) {
        this.cvrSet = cvrSet;
    }

    public List<Double> getBiasSet() {
        return biasSet;
    }

    public void setBiasSet(List<Double> biasSet) {
        this.biasSet = biasSet;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isManagered() {
        return isManagered;
    }

    public void setManagered(boolean managered) {
        isManagered = managered;
    }

    public Integer getManageType() {
        return manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getTarget() {
        return target;
    }

    public void setTarget(Long target) {
        this.target = target;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Double getFactor() {
        return factor;
    }

    public void setFactor(Double factor) {
        this.factor = factor;
    }

    public Double getOrientCostG7d() {
        return orientCostG7d;
    }

    public void setOrientCostG7d(Double orientCostG7d) {
        this.orientCostG7d = orientCostG7d;
    }

    public Double getOrientCostG1d() {
        return orientCostG1d;
    }

    public void setOrientCostG1d(Double orientCostG1d) {
        this.orientCostG1d = orientCostG1d;
    }

    public Double getOrientConvertG1d() {
        return orientConvertG1d;
    }

    public void setOrientConvertG1d(Double orientConvertG1d) {
        this.orientConvertG1d = orientConvertG1d;
    }

    public Double getSlotAdvertCost() {
        return slotAdvertCost;
    }

    public void setSlotAdvertCost(Double slotAdvertCost) {
        this.slotAdvertCost = slotAdvertCost;
    }

    public Double getSlotAdvertConvert() {
        return slotAdvertConvert;
    }

    public void setSlotAdvertConvert(Double slotAdvertConvert) {
        this.slotAdvertConvert = slotAdvertConvert;
    }

    public Double getSlotOrientationCost() {
        return slotOrientationCost;
    }

    public void setSlotOrientationCost(Double slotOrientationCost) {
        this.slotOrientationCost = slotOrientationCost;
    }

    public Double getSlotOrientationConvert() {
        return slotOrientationConvert;
    }

    public void setSlotOrientationConvert(Double slotOrientationConvert) {
        this.slotOrientationConvert = slotOrientationConvert;
    }

    public Double getAppOrientationCost() {
        return appOrientationCost;
    }

    public void setAppOrientationCost(Double appOrientationCost) {
        this.appOrientationCost = appOrientationCost;
    }

    public Double getAppOrientationConvert() {
        return appOrientationConvert;
    }

    public void setAppOrientationConvert(Double appOrientationConvert) {
        this.appOrientationConvert = appOrientationConvert;
    }

    public Long getImportantAppAfee() {
        return importantAppAfee;
    }

    public void setImportantAppAfee(Long importantAppAfee) {
        this.importantAppAfee = importantAppAfee;
    }

    public Integer getCvrType() {
        return cvrType;
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public Integer getReleaseTarget() {
        return releaseTarget;
    }

    public void setReleaseTarget(Integer releaseTarget) {
        this.releaseTarget = releaseTarget;
    }

    public Boolean getFuseWhite() {
        return fuseWhite;
    }

    public void setFuseWhite(Boolean fuseWhite) {
        this.fuseWhite = fuseWhite;
    }

    public AutoMatchInfo getAutoMatchInfo() {
        return autoMatchInfo;
    }

    public void setAutoMatchInfo(AutoMatchInfo autoMatchInfo) {
        this.autoMatchInfo = autoMatchInfo;
    }

    public int getQuailityLevel() {
        return quailityLevel;
    }

    public void setQuailityLevel(int quailityLevel) {
        this.quailityLevel = quailityLevel;
    }

    public HelpMeasureResult getHelpMeasureResult() {
        return helpMeasureResult;
    }

    public void setHelpMeasureResult(HelpMeasureResult helpMeasureResult) {
        this.helpMeasureResult = helpMeasureResult;
    }

    @Override
    public String toString() {
        return "OrientInfo{" +
                "advertId=" + advertId +
                ", orientId=" + orientId +
                ", appId=" + appId +
                ", appOrientCvrDay=" + appOrientCvrDay +
                ", cost20d=" + cost20d +
                ", cvrSet=" + cvrSet +
                ", biasSet=" + biasSet +
                ", type=" + type +
                ", isManagered=" + isManagered +
                ", manageType=" + manageType +
                ", chargeType=" + chargeType +
                ", target=" + target +
                ", fee=" + fee +
                ", factor=" + factor +
                ", orientCostG7d=" + orientCostG7d +
                ", orientCostG1d=" + orientCostG1d +
                ", orientConvertG1d=" + orientConvertG1d +
                ", slotAdvertCost=" + slotAdvertCost +
                ", slotAdvertConvert=" + slotAdvertConvert +
                ", slotOrientationCost=" + slotOrientationCost +
                ", slotOrientationConvert=" + slotOrientationConvert +
                ", appOrientationCost=" + appOrientationCost +
                ", appOrientationConvert=" + appOrientationConvert +
                ", importantAppAfee=" + importantAppAfee +
                ", cvrType=" + cvrType +
                ", releaseTarget=" + releaseTarget +
                ", fuseWhite=" + fuseWhite +
                ", autoMatchInfo=" + autoMatchInfo +
                ", quailityLevel=" + quailityLevel +
                '}';
    }
}