package cn.com.duiba.nezha.alg.common.model.deeptarget;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeepTargetControl {

    private static final Logger logger = LoggerFactory.getLogger(cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl.class);


    static class Constant{

        static double THRESHOLD = 50;//后端转化个数置信阈值
        static double minLevel = 5;//分层区间
        static double minDeltaFactor = 0.5; //双出价调价区间权重增加的最小因子

        /**
         *消耗与昨天相比
         */
        static double[] costRatioBucket = {0, 0.1, 0.2, 0.5, 0.8, 1.0};
        static double[] ratioWeight = {0, 0.1, 0.2, 0.5, 0.8, 1.0};

        /**
         * 消耗绝对值
         */
        static double[] costWeightBucket = {0, 10000, 40000, 80000, 200000,300000};
        static double[] costWeight = {0.0, 0.1, 0.2, 0.5, 0.6, 1.0};

    }

    /**
     * 筛选控制因子
     * @param info
     * @return
     */
    public static DeepTargetInfo getFactor(DeepTargetInfo info) {
        if (AssertUtil.isEmpty(info)) {
            return null;
        }

        //默认初始值
        double selectFactor = 0.02;
        double sdkSelectFactor = 0.02;

        if(info.getAdDeepConvert() > Constant.THRESHOLD){

            double lastSelectFactor = info.getSelectFactor() != 0.0 ? info.getSelectFactor() : selectFactor;
            double lastSdkSelectFactor = info.getSdkSelectFactor() != 0.0 ? info.getSdkSelectFactor() : sdkSelectFactor;

            // 计算调节因子
            if(info.getAdDCvr() < info.getTargetCvr()  && info.getTargetCvr() > 0.0){
                double ratio = info.getAdDCvr() / info.getTargetCvr();
                //非SDK
                double factor = getPredLevelFactor(info.getPreDcvrSum(),info.getPreDcvrPost(),info.getTargetCvr());
                //sdk流量
                double sdkFactor = getPredLevelFactor(info.getPreDcvrSum(),info.getPreDcvrPost(),info.getTargetCvr());

//                selectFactor = Math.max(Math.min(factor/100,info.getTargetCvr()),lastSelectFactor);
//                sdkSelectFactor = Math.max(Math.min(sdkFactor/100,info.getTargetCvr()),lastSdkSelectFactor);
                //2020-06-08 降低放弃概率
                selectFactor = Math.min(Math.max(factor/100,lastSelectFactor),0.85 * info.getTargetCvr());
//                sdkSelectFactor = Math.min(Math.max(sdkFactor/100,lastSdkSelectFactor),0.85 * info.getTargetCvr());
                sdkSelectFactor = selectFactor;
            }

            if(info.getAdDCvr() >= info.getTargetCvr() && info.getAdDCvr() > 0.0){
                double ratio = info.getTargetCvr() / info.getAdDCvr();
                //
                selectFactor = lastSelectFactor * Math.sqrt(ratio);
                selectFactor = Math.min(Math.max(selectFactor,0.005),0.9 * lastSelectFactor);
                sdkSelectFactor = lastSdkSelectFactor * ratio;
                sdkSelectFactor = Math.min(Math.max(sdkSelectFactor,0.005),0.9 * lastSdkSelectFactor);
                sdkSelectFactor = selectFactor;
            }

        }
        // 更新调节因子
        info.setSelectFactor(selectFactor);
        info.setSdkSelectFactor(sdkSelectFactor);

        logger.info("pkg :{}, selectFactor :{}, sdkSelectFactor: {}", info.getPlanId(),selectFactor, sdkSelectFactor);

        return info;
    }

    /**
     * 计算当前位置的右边区间的出单率
     * @param target
     * @param interval
     * @param preLevel
     * @param preDcvrSum
     * @param preDcvrPost
     * @return
     */
    private static Double getLevelPostRatio(double target, double interval, Set<Double> preLevel, Map<Double,Long> preDcvrSum, Map<Double,Long> preDcvrPost){
        double targetLevel = (target % interval == 0) ? Math.floor(target / interval) * interval : Math.floor(target / interval) * interval + interval;

        //当前所处的区间，右边部分
        double sum_preDcvrSum = preDcvrSum.get(targetLevel) * (targetLevel - target) / interval;
        double sum_preDcvrPost = preDcvrPost.get(targetLevel) * (targetLevel - target) / interval;

        //当前所处的区间的所有右边区间（不包含当前区间）
        for(Double level: preLevel){
            if(targetLevel < level){
                sum_preDcvrSum += preDcvrSum.get(level);
                sum_preDcvrPost += preDcvrPost.get(level);
            }
        }
        double sum_preDcvrConvert = sum_preDcvrSum != 0.0 ? sum_preDcvrSum : 1.0;
        return sum_preDcvrPost / sum_preDcvrConvert;
    }

    /**
     * 根据分层预估的结果得到factor
     * @param preDcvrSum
     * @param preDcvrPost
     * @param target
     * @return
     */
    public static Double getPredLevelFactor(Map<Double,Long> preDcvrSum, Map<Double,Long> preDcvrPost,double target) {
        if(AssertUtil.isAnyEmpty(preDcvrSum,preDcvrPost,target)){
            return 0.02;
        }
        Set<Double> preLevel = preDcvrSum.keySet();
        double minLevel = Constant.minLevel;
        for(Double level : preLevel) {
            double ratio = level - target * 100;
            if(ratio >= 0.0 && ratio < 5.0){
               minLevel = level;
            }
        }

        int interval = 5;
        int start = (int)minLevel;

        double ratio_minlevel = getLevelPostRatio(target*100, interval, preLevel, preDcvrSum, preDcvrPost);
        double minGap = Math.abs(target - ratio_minlevel);
        double targetLevel = minLevel;

        for(int i = start; i > 0; i--) {
            double postRatio = getLevelPostRatio(i, interval, preLevel, preDcvrSum, preDcvrPost);
            if(Math.abs(postRatio - target) < minGap){
                //距离目标出单率最近的位置
                targetLevel = (double)i;
                minGap = Math.abs(postRatio - target);
            }
        }

        return targetLevel;
    }


    /**
     * 消耗因子
     * @param info
     * @return
     */
    public static ConsumeInfo getConsumeFactor(ConsumeInfo info){

        if (AssertUtil.isEmpty(info)){
            return null;
        }
        double costRatio = 1.0;
        double consume = info.getConsume();
        Double costConfWeight = getConfidenceWeight(consume, Constant.costWeightBucket, Constant.costWeight, 0.5);
        Double costDayRatio = info.getLastConsume() != 0.0 ? consume/info.getLastConsume() : (costConfWeight);
        Double ratioWeight = getConfidenceWeight(costDayRatio, Constant.costRatioBucket, Constant.ratioWeight, 0.5);

        costRatio = 1 + costConfWeight * ratioWeight;
        info.setConsumeFactor(costRatio);

        
        return info;
    }



    public static Double getConfidenceWeight(Double value, double[] bucketList, double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {

            double lastWeight = weightList[0];
            double lastBound = bucketList[0];

            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];

                double bound = bucketList[i];
                if (value <= bound) {

                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }

                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }


    public static Double getConfidenceWeight2(Double value, double[] bucketList, double[] weightList, double defaultValue) {

        Double ret = defaultValue;

        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            for (int i = 0, size = bucketList.length; i < size; i++) {
                double curWeight = weightList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = curWeight;
                    } else {
                        ret = weightList[0];
                    }
                    break;

                } else if (i == size - 1) {
                    ret = weightList[size - 1];
                }
            }

        }

        return DataUtil.formatDouble(ret, 3);
    }



    public static void main(String[] args){
        double target = 39;
        int interval = 5;
        double targetLevel = (target % interval == 0) ? Math.floor(target / interval) * interval : Math.floor(target / interval) * interval + interval;


        System.out.println(targetLevel);

        Map<Double,Long> preDcvrSum = new HashMap<>();
        Map<Double,Long> preDcvrPost = new HashMap<>();
        preDcvrSum.put(5.0,1322L);
        preDcvrSum.put(10.0,21725L );
        preDcvrSum.put(15.0,23613L );
        preDcvrSum.put(20.0,11826L);
        preDcvrSum.put(25.0,4702L);
        preDcvrSum.put(30.0,1096L);
        preDcvrSum.put(35.0,292L);
        preDcvrSum.put(40.0,61L );
        preDcvrSum.put(45.0,12L);
        preDcvrSum.put(50.0,5L);
        preDcvrSum.put(55.0,0L);
        preDcvrSum.put(60.0,1L);
        preDcvrSum.put(65.0,0L);
        preDcvrSum.put(70.0,0L);
        preDcvrSum.put(75.0,0L);
        preDcvrSum.put(80.0,0L);
        preDcvrSum.put(85.0,0L);
        preDcvrSum.put(90.0,0L);
        preDcvrSum.put(95.0,0L);
        preDcvrSum.put(100.0,0L);

        preDcvrPost.put(5.0,28L);
        preDcvrPost.put(10.0,992L);
        preDcvrPost.put(15.0,1575L);
        preDcvrPost.put(20.0,983L);
        preDcvrPost.put(25.0,467L);
        preDcvrPost.put(30.0,128L);
        preDcvrPost.put(35.0,42L);
        preDcvrPost.put(40.0,6L);
        preDcvrPost.put(45.0,1L);
        preDcvrPost.put(50.0,0L);
        preDcvrPost.put(55.0,0L);
        preDcvrPost.put(60.0,0L);
        preDcvrPost.put(65.0,0L);
        preDcvrPost.put(70.0,0L);
        preDcvrPost.put(75.0,0L);
        preDcvrPost.put(80.0,0L);
        preDcvrPost.put(85.0,0L);
        preDcvrPost.put(90.0,0L);
        preDcvrPost.put(95.0,0L);
        preDcvrPost.put(100.0,0L);


        double ret = getPredLevelFactor(preDcvrSum, preDcvrPost,0.5);
        System.out.println(ret);

        DeepTargetInfo info = new DeepTargetInfo();
        info.setTargetCvr(0.2);
        info.setPreDcvrPost(preDcvrPost);
        info.setPreDcvrSum(preDcvrSum);
        info.setAdDeepConvert(1000L);
        info.setAdDCvr(0.067);
        info.setSelectFactor(0.0);
        info.setSdkSelectFactor(0.0);
        info = getFactor(info);
        System.out.println(JSON.toJSONString(info));



    }
}
