package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.calcUcb;
import static cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb.division;
import static cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl.getConfidenceWeight;

public class AdvertExplore {


    private static final Logger logger = LoggerFactory.getLogger(AdvertExplore.class);



    public static double[] biasBucket = {0.8, 0.9, 1.0, 1.1, 1.2};
    public static double[] factor = {1.2, 1.15, 1.1, 1.05, 1.0};

    /**
     *
     * @param exploreInfos
     * @param exploreParams
     * @param adExploreUcbData
     * @return
     */
    public static List<ExploreResult> explore(List<ExploreInfo> exploreInfos,
                                              ExploreParams exploreParams,
                                              AdExploreUcbData adExploreUcbData) {

        if(AssertUtil.isAnyEmpty(exploreInfos, exploreParams, adExploreUcbData)){
            return null;
        }


        if (Math.random() < 0.0001) {
            logger.info("params AdvertExplore:{}", exploreParams.toString());
        }

        double minprob = exploreParams.getMinProb();//媒体默认探索概率
        double appf1 = exploreParams.getAppf1();//媒体cpm
        double appf2 = exploreParams.getAppf2();//媒体cvr
        double expratio = exploreParams.getExpratio();//
        double bidfactor = exploreParams.getBidfactor();//出价
        double afeefactor = exploreParams.getAfeefactor();
        double ucblimit = exploreParams.getUcblimit();//ucb
        List<Integer> convbucket = exploreParams.getConvbucket();
        List<Integer> cntbucket = exploreParams.getCntbucket();


        List<ExploreResult> exploreResultList = new ArrayList<>(); // 失败也要打日志
        List<ExploreInfo> exploreSubList = new ArrayList<>(); // 结果

        /**
         * 媒体质量过滤
         */
        double appProb = minprob;
        double cpm = 0.0;
        double appCvr = 0.0;
        if(exploreInfos.get(0).appDataInfo.data7Day.consume > 1000 && exploreInfos.get(0).appDataInfo.data7Day.exposure > 100) {
            cpm = division(exploreInfos.get(0).appDataInfo.data7Day.consume, exploreInfos.get(0).appDataInfo.data7Day.exposure);
        }

        if(exploreInfos.get(0).appDataInfo.data7Day.conv != null && exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) != null) {
            if (exploreInfos.get(0).appDataInfo.data7Day.conv.get(0) > 5 && exploreInfos.get(0).appDataInfo.data7Day.click > exploreInfos.get(0).appDataInfo.data7Day.conv.get(0)) {
                appCvr = division(exploreInfos.get(0).appDataInfo.data7Day.conv.get(0),exploreInfos.get(0).appDataInfo.data7Day.click);
            }
        }
        //
        double appProb1 = appf1 * cpm;//25 * 0.4
        double appProb2 = Math.max(appProb1,appf2 * appCvr);//0.1 * 10
        appProb = Math.min(Math.max(appProb2, appProb), 1.0);


        Random r = new Random();
        if (r.nextDouble() > appProb) { //不满足探索条件,所有配置均放弃探索
            for (ExploreInfo exploreInfo : exploreInfos) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP0.getName(), cpm + "_" + appCvr);
                exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
            }
            //直接返回结果
            return exploreResultList;
        }


        for (ExploreInfo exploreInfo : exploreInfos) {
            /**
             * 广告
             */
            //探索消耗达到10%
            double exploreRatio = division(exploreInfo.appAdvertInfo.advertExploreConsume, exploreInfo.appAdvertInfo.advertOcpcConsume);
            double cnt = getCntLimit(exploreInfo.appDataInfo.data3Day.conv.getOrDefault(exploreInfo.convertType,0L),convbucket,cntbucket);

            if(exploreInfo.appAdvertInfo.data3day.exposure > cnt) { //发券达到一定量级
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();

                double cvr = exploreInfo.appOrientConv3day.getOrDefault(exploreInfo.convertType,0L) >= 5 ? division(exploreInfo.appOrientConv3day.getOrDefault(exploreInfo.convertType,0L), exploreInfo.appOrientClick3day) : 0.0;

                if(exploreInfo.appAdvertInfo.data3day.ocpcConsume >= 10000 && cvr > 0.04) { // 利用
                    giveUpReason.put(ReasonType.EXPLOIT.getName(), exploreInfo.appAdvertInfo.data3day.ocpcConsume);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                } else { // 放弃
                    giveUpReason.put(ReasonType.GIVEUP2.getName(), exploreInfo.appAdvertInfo.data3day.exposure);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                }
            } else if(exploreInfo.appAdvertInfo.advertExploreConsume > 2000 && exploreRatio > expratio) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP1.getName(), exploreRatio);
                exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));


            } else {
                /**
                 * 出价筛选配置
                 */
                double bid = 0.0;
                double orientProb1 = 0.1;
                if(exploreInfo.convertType == 0 && exploreInfo.appTradeInfo.data3day.conv != null && exploreInfo.appTradeInfo.data3day.conv.get(exploreInfo.convertType) != null) {
                    double tradeCvr = division(exploreInfo.appTradeInfo.data3day.conv.get(exploreInfo.convertType), exploreInfo.appTradeInfo.data3day.click);
                    bid = exploreInfo.target * tradeCvr;
                    orientProb1 = exploreInfo.appTradeInfo.data3day.conv.get(exploreInfo.convertType) >= 5 ? bid * bidfactor : 0.1;// 0.025,40有100%的概率进来

                }
                double afee = exploreInfo.target;

                double orientProb2 = afee * afeefactor;//0.0005,2000有100%的概率进来
                double orientProb = Math.max(orientProb1,orientProb2);
                //新广告的探索加权
                if (exploreInfo.isSimiFlow == 1.0) {
                    orientProb = Math.min(orientProb * 1.25, 1.0);
                }

                orientProb = Math.max(Math.min(orientProb,1.0),0.1);
                Random r2 = new Random();

                if (r2.nextDouble() > orientProb) {
                    HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                    giveUpReason.put(ReasonType.GIVEUP3.getName(), bid);
                    exploreResultList.add(new ExploreResult(exploreInfo.getAdvertId(), exploreInfo.getOrientationId(), giveUpReason, null));
                } else {
                    exploreSubList.add(exploreInfo);
                }
            }
        }

        /**
         * ucb计算得分并筛选
         */
        if (exploreSubList != null && exploreSubList.size() > 0) {
            Map<Long, UcbResult> ucbMap = calcUcb(exploreSubList.get(0).appDataInfo.data3Day, adExploreUcbData, exploreParams);

            for (ExploreInfo exploreInfo : exploreSubList) {
                exploreInfo.setUcbScore(ucbMap.get(exploreInfo.accountId).getObjUcb().getOrDefault(exploreInfo.convertType,0.0));
            }
            //存储最终用于探索的列表
            List<ExploreInfo> res = exploreSubList.stream()
                    .filter(exploreInfo -> exploreInfo.getUcbScore() >= ucblimit)
                    .sorted(Comparator.comparing(ExploreInfo::getUcbScore).reversed())
                    .limit(50)
                    .collect(Collectors.toList());

            for (ExploreInfo info : res) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.EXPLORE.getName(), "null");

                //调用加价接口，产生加价系数
                double factor = adjustFactor(info, exploreParams);
                exploreResultList.add(new ExploreResult(info.getAdvertId(), info.getOrientationId(), giveUpReason, factor));

            }
            exploreSubList.removeAll(res);
            for (ExploreInfo info : exploreSubList) {
                //ucb过滤掉的结果
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP4.getName(), info.ucbScore);
                exploreResultList.add(new ExploreResult(info.getAdvertId(), info.getOrientationId(), giveUpReason, null));

            }
        }
        return exploreResultList;
    }


    /**
     * 加价接口
     */
    public static double adjustFactor(ExploreInfo exploreInfo, ExploreParams exploreParams) {
        double f = 1.0;
        long consume = exploreInfo.orientOcpcConsume;//消耗
        long conv = exploreInfo.orientConv.getOrDefault(exploreInfo.convertType,0L);//转化
        double cost = conv >= 5 ? division(division(consume, conv), exploreInfo.target) : 1.0;

        f = getConfidenceWeight(cost, biasBucket, factor, 1.0);

        return f;
    }


    public static Integer getCntLimit(Long convCnt,
                                      List<Integer> convbucket,
                                      List<Integer> cntbucket) {
        if(AssertUtil.isAnyEmpty(convCnt,convbucket,cntbucket)){
            return 10;
        }
        if(convCnt <= convbucket.get(0)){
            return cntbucket.get(0);
        } else if(convCnt <= convbucket.get(1)){
            return cntbucket.get(1);
        } else if(convCnt <= convbucket.get(2)){
            return cntbucket.get(2);
        } else{
            return cntbucket.get(3);
        }

    }


    private static double calWilsonScore(long exposeCnt, long clickCnt) {
        // 计算 wilson 置信分数，取99%置信度
        if (exposeCnt == 0) {
            return 0.0;
        }
        double ratio = clickCnt * 1.0 / exposeCnt;
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + (faithSquare / (2 * exposeCnt)) - faithLevel * Math.sqrt(4 * exposeCnt * ratio * (1 - ratio) + faithSquare) / (2 * exposeCnt))
                / (1 + faithSquare / exposeCnt);
    }



    public static void main(String[] args) {
        System.out.println(division(2L,10L));
        List a = new ArrayList();
        List b = new ArrayList();

        b.add(1);
        b.add(1);
        b.add(2);
        b.add(3);
        b.add(4);
        a.addAll(b);
        a.add(5);
        a.removeAll(b);
        System.out.println(b.toString());
        System.out.println(a.toString());


        System.out.println(getConfidenceWeight(0.15, biasBucket, factor, 1.0));

    }


}
