package cn.com.duiba.nezha.alg.common.model.advertexplore;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data

public class ExploreParams {
    // ctr ucb
    private Long ucbAlphaCnt1; // 100
    private List<Double> ucbAlpha1; // [0.1, 0.9, 0.004, 0.016]
    private List<Double> ucbAlpha1start; // [0.9, 0.1, 0.04, 0.16]

    // cvr ucb
    private Long ucbAlphaCnt2; // 100
    private List<Double> ucbAlpha2; // [0.1, 0.9, 0.004, 0.016]
    private List<Double> ucbAlpha2start; // [0.9, 0.1, 0.04, 0.16]

    private Double minProb = 0.1;//媒体默认探索概率
    private Double appf1 = 0.4;//媒体cpm
    private Double appf2 = 10.0;//媒体cvr
    private Double expratio = 0.1;//探索消耗占比
    private Double bidfactor = 0.025;//出价
    private Double afeefactor = 0.0005;
    private Double ucblimit = 0.002;//ucb
    private List<Integer> convbucket = new ArrayList<>();
    private List<Integer> cntbucket = new ArrayList<>();

    // 媒体 曝光置信区间
    private Long appExposeCnt; // 1000L
    private Double appSmooth; // 0.165

    // 媒体&广告主 曝光置信区间
    private Long appAccExposeCnt; // 100L
    private Double appAccSmooth; // 0.125



}
