/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.advertexplore;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb;
import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcbData;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreParams;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreResult;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ReasonType;
import cn.com.duiba.nezha.alg.common.model.advertexplore.UcbResult;
import cn.com.duiba.nezha.alg.common.model.deeptarget.DeepTargetControl;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvertExplore {
    private static final Logger logger = LoggerFactory.getLogger(AdvertExplore.class);
    public static double[] biasBucket = new double[]{0.8, 0.9, 1.0, 1.1, 1.2};
    public static double[] factor = new double[]{1.2, 1.15, 1.1, 1.05, 1.0};

    public static List<ExploreResult> explore(List<ExploreInfo> exploreInfos, ExploreParams exploreParams, AdExploreUcbData adExploreUcbData) {
        if (AssertUtil.isAnyEmpty(exploreInfos, exploreParams, adExploreUcbData)) {
            return null;
        }
        if (Math.random() < 1.0E-4) {
            logger.info("params AdvertExplore:{}", (Object)exploreParams.toString());
        }
        double minprob = exploreParams.getMinProb();
        double appf1 = exploreParams.getAppf1();
        double appf2 = exploreParams.getAppf2();
        double expratio = exploreParams.getExpratio();
        double bidfactor = exploreParams.getBidfactor();
        double afeefactor = exploreParams.getAfeefactor();
        double ucblimit = exploreParams.getUcblimit();
        List<Integer> convbucket = exploreParams.getConvbucket();
        List<Integer> cntbucket = exploreParams.getCntbucket();
        ArrayList<ExploreResult> exploreResultList = new ArrayList<ExploreResult>();
        ArrayList<ExploreInfo> exploreSubList = new ArrayList<ExploreInfo>();
        double appProb = minprob;
        double cpm = 0.0;
        double appCvr = 0.0;
        if (exploreInfos.get((int)0).appDataInfo.data7Day.consume > 1000L && exploreInfos.get((int)0).appDataInfo.data7Day.exposure > 100L) {
            cpm = AdExploreUcb.division(exploreInfos.get((int)0).appDataInfo.data7Day.consume, exploreInfos.get((int)0).appDataInfo.data7Day.exposure);
        }
        if (exploreInfos.get((int)0).appDataInfo.data7Day.conv != null && exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0) != null && exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0) > 5L && exploreInfos.get((int)0).appDataInfo.data7Day.click > exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0)) {
            appCvr = AdExploreUcb.division(exploreInfos.get((int)0).appDataInfo.data7Day.conv.get(0), exploreInfos.get((int)0).appDataInfo.data7Day.click);
        }
        double appProb1 = appf1 * cpm;
        double appProb2 = Math.max(appProb1, appf2 * appCvr);
        appProb = Math.min(Math.max(appProb2, appProb), 1.0);
        Random r = new Random();
        if (r.nextDouble() > appProb) {
            for (ExploreInfo exploreInfo2 : exploreInfos) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(ReasonType.GIVEUP0.getName(), cpm + "_" + appCvr);
                exploreResultList.add(new ExploreResult(exploreInfo2.getAdvertId(), exploreInfo2.getOrientationId(), hashMap, null));
            }
            return exploreResultList;
        }
        for (ExploreInfo exploreInfo3 : exploreInfos) {
            double d = AdExploreUcb.division(exploreInfo3.appAdvertInfo.advertExploreConsume, exploreInfo3.appAdvertInfo.advertOcpcConsume);
            double cnt = AdvertExplore.getCntLimit(exploreInfo3.appDataInfo.data3Day.conv.getOrDefault(exploreInfo3.convertType, 0L), convbucket, cntbucket).intValue();
            if ((double)exploreInfo3.appAdvertInfo.data3day.exposure.longValue() > cnt) {
                double cvr;
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                double d2 = cvr = exploreInfo3.appOrientConv3day.getOrDefault(exploreInfo3.convertType, 0L) >= 5L ? AdExploreUcb.division(exploreInfo3.appOrientConv3day.getOrDefault(exploreInfo3.convertType, 0L), exploreInfo3.appOrientClick3day) : 0.0;
                if (exploreInfo3.appAdvertInfo.data3day.ocpcConsume >= 10000L && cvr > 0.04) {
                    giveUpReason.put(ReasonType.EXPLOIT.getName(), exploreInfo3.appAdvertInfo.data3day.ocpcConsume);
                    exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                    continue;
                }
                giveUpReason.put(ReasonType.GIVEUP2.getName(), exploreInfo3.appAdvertInfo.data3day.exposure);
                exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                continue;
            }
            if (exploreInfo3.appAdvertInfo.advertExploreConsume > 2000L && d > expratio) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP1.getName(), d);
                exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                continue;
            }
            double bid = 0.0;
            double orientProb1 = 0.1;
            if (exploreInfo3.convertType == 0 && exploreInfo3.appTradeInfo.data3day.conv != null && exploreInfo3.appTradeInfo.data3day.conv.get(exploreInfo3.convertType) != null) {
                double tradeCvr = AdExploreUcb.division(exploreInfo3.appTradeInfo.data3day.conv.get(exploreInfo3.convertType), exploreInfo3.appTradeInfo.data3day.click);
                bid = (double)exploreInfo3.target.longValue() * tradeCvr;
                orientProb1 = exploreInfo3.appTradeInfo.data3day.conv.get(exploreInfo3.convertType) >= 5L ? bid * bidfactor : 0.1;
            }
            double afee = exploreInfo3.target.longValue();
            double orientProb2 = afee * afeefactor;
            double orientProb = Math.max(orientProb1, orientProb2);
            if ((double)exploreInfo3.isSimiFlow.intValue() == 1.0) {
                orientProb = Math.min(orientProb * 1.25, 1.0);
            }
            orientProb = Math.max(Math.min(orientProb, 1.0), 0.1);
            Random r2 = new Random();
            if (r2.nextDouble() > orientProb) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP3.getName(), bid);
                exploreResultList.add(new ExploreResult(exploreInfo3.getAdvertId(), exploreInfo3.getOrientationId(), giveUpReason, null));
                continue;
            }
            exploreSubList.add(exploreInfo3);
        }
        if (exploreSubList != null && exploreSubList.size() > 0) {
            Map<Long, UcbResult> ucbMap = AdExploreUcb.calcUcb(((ExploreInfo)exploreSubList.get((int)0)).appDataInfo.data3Day, adExploreUcbData, exploreParams);
            for (ExploreInfo exploreInfo4 : exploreSubList) {
                exploreInfo4.setUcbScore(ucbMap.get(exploreInfo4.accountId).getObjUcb().getOrDefault(exploreInfo4.convertType, 0.0));
            }
            List list = exploreSubList.stream().filter(exploreInfo -> exploreInfo.getUcbScore() >= ucblimit).sorted(Comparator.comparing(ExploreInfo::getUcbScore).reversed()).limit(50L).collect(Collectors.toList());
            for (ExploreInfo exploreInfo5 : list) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.EXPLORE.getName(), "null");
                double factor = AdvertExplore.adjustFactor(exploreInfo5, exploreParams);
                exploreResultList.add(new ExploreResult(exploreInfo5.getAdvertId(), exploreInfo5.getOrientationId(), giveUpReason, factor));
            }
            exploreSubList.removeAll(list);
            for (ExploreInfo exploreInfo6 : exploreSubList) {
                HashMap<String, Object> giveUpReason = new HashMap<String, Object>();
                giveUpReason.put(ReasonType.GIVEUP4.getName(), exploreInfo6.ucbScore);
                exploreResultList.add(new ExploreResult(exploreInfo6.getAdvertId(), exploreInfo6.getOrientationId(), giveUpReason, null));
            }
        }
        return exploreResultList;
    }

    public static double adjustFactor(ExploreInfo exploreInfo, ExploreParams exploreParams) {
        double f = 1.0;
        long consume = exploreInfo.orientOcpcConsume;
        long conv = exploreInfo.orientConv.getOrDefault(exploreInfo.convertType, 0L);
        double cost = conv >= 5L ? AdExploreUcb.division(AdExploreUcb.division(consume, (Long)conv), exploreInfo.target) : 1.0;
        f = DeepTargetControl.getConfidenceWeight(cost, biasBucket, factor, 1.0);
        return f;
    }

    public static Integer getCntLimit(Long convCnt, List<Integer> convbucket, List<Integer> cntbucket) {
        if (AssertUtil.isAnyEmpty(convCnt, convbucket, cntbucket)) {
            return 10;
        }
        if (convCnt <= (long)convbucket.get(0).intValue()) {
            return cntbucket.get(0);
        }
        if (convCnt <= (long)convbucket.get(1).intValue()) {
            return cntbucket.get(1);
        }
        if (convCnt <= (long)convbucket.get(2).intValue()) {
            return cntbucket.get(2);
        }
        return cntbucket.get(3);
    }

    private static double calWilsonScore(long exposeCnt, long clickCnt) {
        if (exposeCnt == 0L) {
            return 0.0;
        }
        double ratio = (double)clickCnt * 1.0 / (double)exposeCnt;
        double faithLevel = 0.99;
        double faithSquare = faithLevel * faithLevel;
        return (ratio + faithSquare / (double)(2L * exposeCnt) - faithLevel * Math.sqrt((double)(4L * exposeCnt) * ratio * (1.0 - ratio) + faithSquare) / (double)(2L * exposeCnt)) / (1.0 + faithSquare / (double)exposeCnt);
    }

    public static void main(String[] args) {
        System.out.println(AdExploreUcb.division(2L, (Long)10L));
        ArrayList a = new ArrayList();
        ArrayList<Integer> b = new ArrayList<Integer>();
        b.add(1);
        b.add(1);
        b.add(2);
        b.add(3);
        b.add(4);
        a.addAll(b);
        a.add(5);
        a.removeAll(b);
        System.out.println(((Object)b).toString());
        System.out.println(((Object)a).toString());
        System.out.println(DeepTargetControl.getConfidenceWeight(0.15, biasBucket, factor, 1.0));
    }
}

