/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.model.adjustprice;

import cn.com.duiba.nezha.alg.common.model.advertexplore.AdExploreUcb;
import cn.com.duiba.nezha.alg.common.model.advertexplore.ExploreInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;

public class AdjustPrice {
    public static double adjustFactor(ExploreInfo exploreInfo, Double[] biasBucket, Double[] factor, Double[] expBiasBucket, Double[] expFactor, Double[] bidRatioBucket, Double[] bidFactor, Double biasWeight, Double limitFactor) {
        double finalF = 1.0;
        if (!AssertUtil.isAnyEmpty(exploreInfo.getAppAdvertInfo(), exploreInfo.getAppAccountInfo())) {
            long consume = exploreInfo.getOrientOcpcConsume();
            long conv = exploreInfo.getOrientConv().getOrDefault(exploreInfo.getConvertType(), 0L);
            double cost = conv >= 5L ? AdExploreUcb.division(AdExploreUcb.division(consume, (Long)conv), exploreInfo.getTarget()) : 1.0;
            double f1 = AdjustPrice.getConfidenceWeight(cost, biasBucket, factor, 1.0);
            double exploreCost = 1.0;
            if (exploreInfo.getOrientExpCost() != null && exploreInfo.getOrientExpCost().getExploreAdjConsume() > 3000L) {
                exploreCost = AdExploreUcb.division(exploreInfo.getOrientExpCost().getExploreConsume(), exploreInfo.getOrientExpCost().getExploreAdjConsume());
            } else if (exploreInfo.getAppAdvertInfo().getConsume() != null && exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() != null && exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume() > 5000L) {
                exploreCost = AdExploreUcb.division(exploreInfo.getAppAdvertInfo().getConsume().getExploreConsume(), exploreInfo.getAppAdvertInfo().getConsume().getExploreAdjConsume());
            } else if (exploreInfo.getAppAccountInfo().getConsume() != null && exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() != null && exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume() > 5000L) {
                exploreCost = AdExploreUcb.division(exploreInfo.getAppAccountInfo().getConsume().getExpConsume(), exploreInfo.getAppAccountInfo().getConsume().getExploreAdjConsume());
            } else {
                biasWeight = 1.0;
            }
            double f2 = AdjustPrice.getConfidenceWeight(exploreCost, expBiasBucket, expFactor, 1.0);
            double f = biasWeight * f1 + (1.0 - biasWeight) * f2;
            double ratio = AdExploreUcb.division(exploreInfo.getAppAdvertInfo().getAppAdExpCnt(), exploreInfo.getAppAdvertInfo().getAppAdBidCnt());
            double f3 = AdjustPrice.getConfidenceWeight(ratio, bidRatioBucket, bidFactor, 1.0);
            finalF = f * f3;
            finalF = Math.max(Math.min(finalF, limitFactor), 1.0);
        }
        return finalF;
    }

    public static Double getConfidenceWeight(Double value, Double[] bucketList, Double[] weightList, double defaultValue) {
        Double ret = defaultValue;
        if (value != null && bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            int size = bucketList.length;
            for (int i = 0; i < size; ++i) {
                double curWeight = weightList[i];
                double curBound = bucketList[i];
                double bound = bucketList[i];
                if (value <= bound) {
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = weightList[0];
                    break;
                }
                if (i == size - 1) {
                    ret = weightList[size - 1];
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble(ret, 3);
    }
}

