/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.common.util;

import cn.com.duiba.wolf.utils.Base58;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class BlowfishUtils {
    private static final String CIPHER_NAME = "Blowfish/CFB8/NoPadding";
    private static final String KEY_SPEC_NAME = "Blowfish";
    private static final ThreadLocal<HashMap<String, BlowfishUtils>> pool = new ThreadLocal();
    private Cipher enCipher;
    private Cipher deCipher;
    private String key;

    private BlowfishUtils(String key) {
        try {
            this.key = key;
            String iv = StringUtils.substring((String)DigestUtils.md5Hex((String)key), (int)0, (int)8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), KEY_SPEC_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            this.enCipher = Cipher.getInstance(CIPHER_NAME);
            this.deCipher = Cipher.getInstance(CIPHER_NAME);
            this.enCipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            this.deCipher.init(2, (Key)secretKeySpec, ivParameterSpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String encrypt(String s) {
        String result = null;
        if (StringUtils.isNotBlank((String)s)) {
            try {
                byte[] encrypted = this.enCipher.doFinal(s.getBytes());
                result = new String(Base58.encode((byte[])encrypted));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private String decrypt(String s) {
        String result = null;
        if (StringUtils.isNotBlank((String)s)) {
            try {
                byte[] decrypted = Base58.decode((String)s);
                result = new String(this.deCipher.doFinal(decrypted));
            }
            catch (Exception e) {
                this.resetInstance();
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void resetInstance() {
        pool.set(null);
    }

    public static String encryptBlowfish(String s, String key) {
        return BlowfishUtils.getInstance(key).encrypt(s);
    }

    public static String decryptBlowfish(String s, String key) {
        return BlowfishUtils.getInstance(key).decrypt(s);
    }

    public static String encryptBlowfish(String s) {
        return BlowfishUtils.encryptBlowfish(s, "abc");
    }

    public static String decryptBlowfish(String s) {
        return BlowfishUtils.decryptBlowfish(s, "abc");
    }

    private static BlowfishUtils getInstance(String key) {
        BlowfishUtils instance;
        HashMap<String, BlowfishUtils> keyMap = pool.get();
        if (keyMap == null || keyMap.isEmpty()) {
            keyMap = new HashMap();
            pool.set(keyMap);
        }
        if ((instance = keyMap.get(key)) == null || !StringUtils.equals((String)instance.key, (String)key)) {
            instance = new BlowfishUtils(key);
            keyMap.put(key, instance);
        }
        return instance;
    }

    public static void main(String[] strings) {
        String str1 = "2udaaLDuxNmWjrP11aLRQQuyWzsUt72EFjSYzM1nxJurELPRyvg7ByKahBbehGhr64JZnu1XLzfep9sWs9QiVxDbrspYC2rzCuw91ff";
        String str11 = "m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ";
        String str2 = "m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ";
        String str3 = "2HdqLj186jqLBR5xkSAXCjSuFeiSLJFk5tgbeH39mVDTHer6iCT4iJ2SwbNC4j3K4ooARZ6AnijRMuuEBgYuYYxZRyGujNf7sQD";
        String str4 = "m8KNoW94S2D9SK8wHVsW8NZ11Y9KcYT2RW1K98Fh5uzJiYQqDgP2dnCMB6J3nmuvw39hqaAgbiGxTDZ";
        String str5 = "2fzE3mgAo4bbSg2y3WfGaJ1KGTEqwZ8AAQcP5tAqbiwRSJ8QCQnzTc8G3QUjmMTsJ3kc8ZMNVJcRziV6drHKQWJ4";
        List<String> ft200118List = Arrays.asList("3ZZJqnXYr7yvezYkx", "3cZtvqSKTc7Uncppo", "2Bvesp1WZ", "4oBL1sdS1WrvPFbgRVibE", "2i4gHjMbJq8mk", "2mD1jmLiZ2Jfx", "2BxbmT6vz", "29pDLXh5V");
        for (String subft200118 : ft200118List) {
            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200118);
            System.out.println(subMatDecode);
        }
        List<String> ft200119List = Arrays.asList("29WzifjAv", "2AV8SFfVY", "2hbY9xP5baAHR", "2j4WvtaTLg42v");
        for (String subft200119 : ft200119List) {
            String subMatDecode = BlowfishUtils.decryptBlowfish(subft200119);
            System.out.println(subMatDecode);
        }
    }
}

