package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import com.alibaba.fastjson.JSON;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.Graph;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;

import java.io.File;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LocalTFModelTest {

    public static Logger logger = LoggerFactory.getLogger(LocalTFModelTest.class);

    public static String feature ="{\"f4010010\":\"Mozilla/5.0 (Linux; Android 6.0; CAM-AL00 Build/HONORCAM-AL00; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/57.0.2987.132 MQQBrowser/6.2 TBS/044328 Mobile Safari/537.36 mojia/1007010802\",\"f4010091\":\"2\",\"f3010120\":\"1\",\"f2010030\":\"4\",\"f4010090\":\"2\",\"f1010010\":\"11\",\"f5010060\":\"0\",\"f4010041\":\"0\",\"f4010121\":\"21\",\"f2010020\":\"0\",\"f4010080\":\"1\",\"f3010010\":\"5128\",\"f3010130\":\"0\",\"f6010020\":\"com.moji.mjweather\",\"f5010070\":\"0\",\"f4010122\":\"3\",\"f4010031\":\"86\",\"f4010030\":\"6102\",\"f4010110\":\"108.86984\",\"f4010070\":\"0\",\"f2010050\":\"4\",\"f6010010\":\"mojiWeather\",\"f2010010\":\"80\",\"f3010060\":\"60\",\"f6010090\":\"80\",\"f5010080\":\"0\",\"f4010020\":\"111.18.90.230\",\"f3010070\":\"60\",\"f4010060\":\"CAM-AL00\",\"f1010020\":\"3\",\"f5010090\":\"0\",\"f5010050\":\"864233033321573\",\"f5010010\":\"O\",\"f4010100\":\"34.865234\"}";

    public static Map<String, String> featureIdxMap = (Map) JSON.parseObject(feature);


    public static void main(String[] args) {

//        test2();

//        test55();

//        test1();
//        sync1();
//        testLoadTF();

        test5();
    }


    public static void getAllFileName(String path, List<String> listFileName) {
        File file = new File(path);
        if (file.isDirectory()) {
            listFiles(file);
        }


//        for (File a : files) {
//            if (a.isDirectory()) {//如果文件夹下有子文件夹，获取子文件夹下的所有文件全路径。
//                getAllFileName(a.getAbsolutePath() + "\\", listFileName);
//            }
//        }
    }

    public static void listFiles(File directory) {

        File[] listFiles = directory.listFiles();
        for (int i = 0; i < listFiles.length; i++) {
            File f = listFiles[i];
            System.out.println(f.getName() + "-" + f.lastModified());
        }

    }


    public static void test2() {

        try {
            LocalTFModel model = new LocalTFModel();
            model.loadModel("/Users/lwj/Desktop/model/");
        } catch (Exception e) {

        }

    }

    public static void test1() {


        CODER ctrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("adx_coder_dqn_v001");

        System.out.println("ctrModel=" + JSON.toJSONString(ctrModel.getUpdateTime()));

        LocalTFModel model = new LocalTFModel();

        try {


            model.loadModel("/Users/lwj/Desktop/model");

            Map<String, Map<String, String>> map = new HashMap<>();

            for (int i = 0; i < 10; i++) {
                map.put("A" + i, featureIdxMap);
            }
            System.out.println(JSON.toJSONString(ctrModel.predictWithLocalTF(map, model)));

            for (int i = 0; i < 100; i++) {
                map.put("A" + i, featureIdxMap);
            }

            System.out.println(LocalDateTime.now());
            for (int i = 0; i < 10; i++) {
                ctrModel.predictWithLocalTF(map, model);
            }
            System.out.println(LocalDateTime.now());


            System.out.println();


        } catch (Exception e) {
            System.out.println(e);
        }

    }

    public static void test6() {


        CODER ctrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("adx_coder_dqn_v001");

        System.out.println("ctrModel=" + JSON.toJSONString(ctrModel.getUpdateTime()));

        LocalTFModel model = new LocalTFModel();

        try {


            model.loadModel("/Users/lwj/Desktop/model","101");
            Map<String, Map<String, String>> map = new HashMap<>();

            map.put("A", featureIdxMap);

            System.out.println(JSON.toJSONString(ctrModel.predictWithLocalTF(map, model)));


        } catch (Exception e) {
            System.out.println(e);
        }

    }

    public static void test55() {


        List<Long> tList = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
//        tList.parallelStream().forEach(a -> test5(a));
    }

    public static void test5() {

        CODER ctrModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_ctr_v001");

//        CODER ctrModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001");

        JedisConfig jcOffline = new JedisConfig();
        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);



        try {

//            CODER ctrModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001", juOffline);

            Map<String, Map<String, String>> map = new HashMap<>();

            Map<Long, LocalTFModel> mMap = new HashMap<>();
            LocalTFModel model = localTfModelCache.get("/Users/lwj/Desktop/model2/");


            for (int i1 = 0; i1 < 100; i1++) {
                map.put("A" + i1, featureIdxMap);
            }
//            System.out.println(JSON.toJSONString(ctrModel.predictWithLocalTF(map, model)));

            for(int j=0;j<100;j++){

                System.out.println("j="+j+",startTime="+LocalDateTime.now());
                for (int i = 0; i < 1000; i++) {
                    ctrModel.predictWithLocalTF(map, model);
                }
                System.out.println("j="+j+",endTime="+LocalDateTime.now());

            }


        } catch (Exception e) {
            System.out.println(e);
        }

    }

    public static void test3() {

        IModel ctrModel = StdModelSave.getModelByKeyFromJedis("mid_ftrl_fm_ctr_v007");

        try {


            Map<String, Map<String, String>> map = new HashMap<>();

            for (int i = 0; i < 50; i++) {
                map.put("B" + i, featureIdxMap);
            }
            System.out.println(JSON.toJSONString(ctrModel.predicts(map)));

            System.out.println(LocalDateTime.now());

            for (int i = 0; i < 1000; i++) {
                ctrModel.predicts(map);
                Thread.sleep(5000);
            }

            System.out.println(LocalDateTime.now());

            System.out.println();


        } catch (Exception e) {
            System.out.println(e);
        }

    }


    public static void sync1() {
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        CODER ctrModel = StdCoderModelSaveBo.getADXModelCoderByKeyFromJedis("adx_coder_dqn_v001", juOffline);

        System.out.println(ctrModel.getUpdateTime());

        StdCoderModelSaveBo.saveModelCoderByKeyToJedis("mid_act_resplug_coder_v001", ctrModel, juOffline);
    }


    public static void testLoadTF() {


        try {
            Map<String, LocalTFModel> map = new HashMap<>();

            for (int i = 0; i < 1000; i++) {
                LocalTFModel model = new LocalTFModel();
                model.loadModel("/Users/lwj/Desktop/model/");
                map.put("1", model);
                System.out.println(i);
//                Thread.sleep(1000*3);
            }

        } catch (Exception e) {
            System.out.println(e);
        }


    }


    private static Queue<LocalTFModel> localTFModelQueue = new LinkedList<LocalTFModel>();

    private static LoadingCache<String, LocalTFModel> localTfModelCache = CacheBuilder.newBuilder()
            .maximumSize(1)
            .refreshAfterWrite(3, TimeUnit.MINUTES)
            .expireAfterWrite(1, TimeUnit.HOURS)
            .build(new CacheLoader<String, LocalTFModel>() {
                @Override
                public LocalTFModel load(String key) {
                    // 1. 本地深度模型加载
                    LocalTFModel ltfModel = new LocalTFModel();
                    try {
//
//                        System.out.println("load");
//                        String v = "101";
//                        if (Math.random() > 0.5) {
//                            v = "100";
//                        }
                        ltfModel.loadModel(key);

                    } catch (Exception e) {
                        logger.error("rspPlugin algo get ltfModel error..." + e);
                    }

                    // 2. 释放上一个模型：load()是单线程阻塞执行，不会出现多线程并发问题
                    try {
                        while (localTFModelQueue.size() > 1) {
                            System.out.println("q.size=" + localTFModelQueue.size());
                            LocalTFModel poll = localTFModelQueue.poll();
                            // 过了一个周期（10分钟）才关闭模型，这样子不会关闭正在使用模型
                            // TensFlow通过Python调用系统底层，模型不关闭会占用jvm之外的内存

                            assert poll != null;
                            poll.close();

                            poll=null;


                        }
                    } catch (Exception e) {
                        System.out.println("algo LocalTFModel e：" + e);
                    }

                    // 3. 当前模型添加到队列，这样队列就有当前模型和上一个模型
                    localTFModelQueue.add(ltfModel);
                    return ltfModel;
                }
            });
}
