package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdxModelTest {

    public static void main(String[] args) {
        try {

//            testAdx11();
            testDmp();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void testDmp() throws Exception {
        String key = "adx_mid_ftrl_fm_ctr_v001";
        String key1 = "adx_mid_ftrl_fm_ctr_v002";
        String key2 = "adx_mid_ftrl_fm_ctr_v003";


        FM model = StdModelSave.getADXModelByKeyFromJedis(key);
        FM model1 = StdModelSave.getADXModelByKeyFromJedis(key1);
        FM model2 = StdModelSave.getADXModelByKeyFromJedis(key2);


        String str="{\"f4010010\":\"Cupid/qc_100001_100086/5.53.011;NetType/wifi;QTP/1.1.38.4\",\"f7030011\":\"0\",\"f3010120\":\"1\",\"f2010030\":\"0\",\"f4010090\":\"2\",\"f1010010\":\"96\",\"f7010010\":\"020101,020105,020308,020310,020408,020601,020702,02070602,020710,020714,020801,020811,021118,021119,021308,021404,022406\",\"f7010011\":\"4\",\"f5010060\":\"1\",\"f7020010\":\"6047,8319,4999,6675,9037,7856,1220,8633,1283,5808,7866,8852,7860,77,3902,7422,8305,468,648,7868,1165,2223,7129,7413,7751,2187\",\"f7020011\":\"6\",\"f4010121\":\"12\",\"f2010020\":\"0\",\"f3010010\":\"8633\",\"f3010130\":\"47\",\"f5010070\":\"1\",\"f4010122\":\"3\",\"f4010031\":\"84\",\"f4010030\":\"4690\",\"f4010070\":\"0\",\"f2010050\":\"\",\"f2010010\":\"779\",\"f3010060\":\"720\",\"f6010090\":\"1000000000381\",\"f5010080\":\"0\",\"f4010020\":\"139.189.220.103\",\"f3010070\":\"1280\",\"f4010060\":\"vivo Y85A\",\"f3010030\":\"0\",\"f1010020\":\"12\",\"f5010090\":\"0\",\"f5010050\":\"a003057537d660960db5a09d22199995\",\"f5010010\":\"O\"}";


        Map<String, String> map = (Map)JSON.parse(str);

        System.out.println(model.predict(map));
        System.out.println(model1.predict(map));
        System.out.println(model2.predict(map));

    }

    public static void testAdx11() {

        JedisConfig jcOnline = new JedisConfig();
        jcOnline.setIp("r-bp18da0abeaddc94285.redis.rds.aliyuncs.com");
        jcOnline.setPassWord("hteK73Zxx3ji9LGCy2jBAZDJ6");
        jcOnline.setPort(6379);

        JedisUtil juOnline = new JedisUtil(jcOnline);
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("47.111.157.152");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);


        try {

            /*
            String key = "adx_mid_ftrl_fm_ctr_v002";
            String key2 = "adx_mid_ftrl_fm_ctr_v003";
            FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("model=" + key + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);
            FM modelTest = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("modelTest=" + key2 + ",model.UpdateTime = " + modelTest.getUpdateTime() + ",model_ps = " + modelTest.getModelId());
            */

            String key = "adx_mid_ftrl_fm_ctr_v001";
            String key2 = "adx_mid_ftrl_fm_ctr_v004";
            //FM model = StdModelSave.getModelByKeyFromJedis(key, juOnline);
            FM model = StdModelSave.getADXModelByKeyFromJedis(key, juOnline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("model=" + key + ",model.UpdateTime = " + model.getUpdateTime() + ",model_ps = " + model.getModelId());

            //StdModelSave.saveModelByKeyToJedis(key2, model, juOffline);
            //FM modelTest = StdModelSave.getModelByKeyFromJedis(key2, juOffline);
            StdModelSave.saveADXModelByKeyToJedis(key2, model, juOffline);
            FM modelTest = StdModelSave.getADXModelByKeyFromJedis(key2, juOffline);
            System.out.println(LocalDateUtil.getCurrentLocalDateTime(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
            System.out.println("modelTest=" + key2 + ",model.UpdateTime = " + modelTest.getUpdateTime() + ",model_ps = " + modelTest.getModelId());


        } catch (Exception e) {
            e.printStackTrace();
        }


    }
}
