/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.DCVR;
import cn.com.duiba.nezha.alg.model.ESMM;
import cn.com.duiba.nezha.alg.model.FM;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CoderReadTest {
    public static void main(String[] args) {
        try {
            CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_dcvr_v101");
            TFServingClient tfServingClient = new TFServingClient("10.50.203.93", 9000, "esmm-dcvr-001", null);
            String featureStr = "{\"f431001\":\"1\",\"f431003\":\"0\",\"f431002\":\"1\",\"f213001\":\"158,112,97,61,289,133,219,49,242,37\",\"f213002\":\"1213,265,589,134,1297,2149,1009,2581,385,565,2341,517,229,1093,2281,85,625,1861,1633,1693,1909,110,1789,1345,601,397,2245,2497,433,2858,313\",\"f213003\":\"157,113,97,61,289,133,217,49,243,38\",\"f213004\":\"1213,265,589,133,1297,1009,2581,385,565,2341,517,1093,85,1861,1633,111,1345,602,433,2857,313\",\"f603002\":\"5\",\"f603001\":\"5\",\"f110001\":\"0\",\"f809001\":\"1\",\"f809002\":\"1\",\"f144009\":\"0\",\"f144007\":\"0\",\"f144008\":\"0\",\"f144005\":\"0\",\"f144006\":\"0\",\"f144003\":\"0\",\"f144004\":\"0\",\"f144001\":\"0\",\"f144002\":\"0\",\"f201001\":\"69640\",\"f660001\":\"20\",\"f144010\":\"0\",\"f810001\":\"1\",\"f810002\":\"0\",\"f306001\":\"2\",\"chargeType\":\"2\",\"f601001\":\"5\",\"f601002\":\"5\",\"f410001\":\"5\",\"f811001\":\"106,202\",\"f212004\":\"1924,422,936,214,347,2063,1601,4507,4089,2208,612,899,2454,3710,4467,823,1732,139,2955,2588,178,4391,2140,957,1580,688,4526,501\",\"f212003\":\"251,268,462,346,288,177,155,98,325,213,230,79,384,62\",\"f212002\":\"1924,422,841,348,2064,1602,4507,4089,2209,612,4467,1732,3614,140,119,2955,3026,178,2835,4392,2140,4363,3558,688,1990,937,221,3405,707,3652,901,2454,3710,824,367,998,2588,2683,957,632,1581,3958,536,4527,503\",\"f212001\":\"252,268,463,348,288,176,155,98,325,213,230,2,79,384,63\",\"f602001\":\"7\",\"f211003\":\"157,169,289,218,181,110,97,62,206,133,145,49,242,38\",\"f211002\":\"1213,265,529,217,1297,1009,2845,2581,1393,385,2822,1093,2281,85,73,1861,1909,109,1789,2773,1345,2749,2245,433,1249,589,134,2149,445,2305,565,1549,2341,517,229,625,1633,1693,601,397,997,2497,337,2857,313\",\"f211001\":\"157,169,289,220,181,109,97,62,205,133,145,1,49,241,39\",\"f811002\":\"106\",\"f660201\":\"0\",\"f211004\":\"1213,265,589,133,217,1297,1009,2845,2581,1393,385,565,1549,2341,2823,517,1093,85,1861,1633,109,2773,1345,601,997,433,2857,313\",\"f112001\":\"05.02.0020\",\"f101001\":\"63824\",\"f432006\":\"0\",\"f432005\":\"0\",\"f432002\":\"0\",\"f432001\":\"0\",\"f432004\":\"0\",\"f432003\":\"0\",\"f602002\":\"7\",\"orderId\":\"taw-1570197535980207\",\"f113001\":\"04.01.0006,04.03.0019\",\"f502001\":\"2\",\"f502002\":\"3\",\"f451003\":\"01050304\",\"f451002\":\"010212\",\"f451004\":\"05011701\",\"f451001\":\"010102\",\"f770501\":\"0\",\"f606002\":\"1\",\"f606001\":\"1\",\"f102001\":\"02.01.0002\",\"f301001\":\"20318\",\"advertId\":\"63824\",\"f210001\":\"157,169,289,218,181,109,97,63,208,133,145,1,49,241,37\",\"f210002\":\"1213,265,529,217,1297,1009,2845,2581,1393,385,2825,1093,2281,85,73,1861,1909,109,1789,2774,1345,2245,433,1249,589,133,2149,445,2305,565,1549,2341,517,229,625,1633,1693,601,397,997,2497,337,2857,313\",\"f770401\":\"0\",\"f210003\":\"157,169,289,218,181,109,97,62,208,133,145,49,241,37\",\"f770402\":\"0\",\"f210004\":\"1213,265,589,133,217,1297,1009,2845,2581,1393,385,565,1549,2341,2827,517,1093,85,1861,1633,109,2773,1345,601,997,433,2857,313\",\"f604002\":\"6\",\"f604001\":\"6\",\"f501001\":\"Android\",\"f303001\":\"30\",\"f462002\":\"0\",\"consumerId\":\"21657683151\",\"f406001\":\"0\",\"f462001\":\"\u8da3\u5934\u6761\",\"f115001\":\"0\",\"f605001\":\"1\",\"f605002\":\"1\",\"f302001\":\"20318\",\"f608001\":\"0\",\"f425011\":\"0\",\"f425004\":\"0\",\"f104001\":\"91654\",\"f414004\":\"5\",\"f414001\":\"112\",\"f414007\":\"6\",\"f414008\":\"0\",\"f414005\":\"2\",\"f425012\":\"0\",\"f770102\":\"1\",\"f413002\":\"133,92,142,55,175,242,115,185,122,42,34,204\",\"f413003\":\"113,32\",\"f413001\":\"133,93,142,56,175,243,116,185,122,42,35,204\",\"f413006\":\"0\",\"f413007\":\"10\",\"f413004\":\"3\",\"f413005\":\"2\",\"f413008\":\"0\",\"f461002\":\"5,112,12,122,23,43,55,63,73,83,93\",\"f461001\":\"72\",\"f461009\":\"133\",\"f609001\":\"1\",\"f804004\":\"9\",\"f804003\":\"11\",\"f804002\":\"15\",\"f804001\":\"15\",\"f461010\":\"22,372\",\"f770001\":\"07.19.0013\",\"f415004\":\"8\",\"f415005\":\"4\",\"f415007\":\"11\",\"f504001\":\"V1932A\",\"f607001\":\"0\",\"f403004\":\"0\",\"f805001\":\"6\",\"f805002\":\"14\",\"f805003\":\"5\",\"f805004\":\"8\",\"f9940\":\"11,14,28,37,51,68,75,88,99,112,121,134,146,157,169\",\"f9941\":\"239|216|8450,2864,239|8695,8852,1583,1220,8450,1182,2424,2864,1213,1254,239,8662,9037,11072,7134,6047,4222,7413,1473,3451,2952,1742,2871,7129,647,10101,648,9901,5305,7606,7607,1823,7860,2090,8397,9522,7742,5083,1632,1199,216,537,3895,7856,8766,7795,7751,5211,2187,7592,3902,1525,667,7866,7745,4799,8916|||8852,1583,1220,8450,1182,2424,2864,1213,1254,239,9037,11072,7134,6047,3692,4222,7413,1473,3451,2952,1742,2871,7129,647,10101,648,9901,7606,7607,1823,7860,2090,8397,9522,3860,7742,5083,1632,1199,537,3895,7856,3976,8766,7795,7751,5211,2187,7592,3902,1525,667,3861,7866,7745,8916|1583,1182,1742,2871,9901,1823,9522,7742,5083,667,7745,8916|8695||8695,8852,1583,1220,8450,1182,2424,2864,1213,1254,239,8662,9037,11072,7134,6047,3692,4222,7413,1473,3451,2952,1742,2871,7129,647,10101,648,9901,5305,7606,7607,1823,7860,2090,8397,9522,3860,7742,5083,1632,1199,216,537,3895,7856,3976,8766,7795,7751,5211,2187,7592,3902,1525,667,3861,7866,7745,4799,8916|1583,1213,1254,239,2871,647,10101,7607,2090,1632,216,3976,8766,7795,1525,7866,7745,4799,8916|8450,1182,2424,2864,1254,239,9037,11072,7134,6047,4222,7413,1473,3451,2952,2871,7129,647,648,9901,5305,7606,7860,8397,9522,3860,7742,5083,1632,1199,216,537,8766,7751,5211,3902,1525,7866,7745,4799,8916\",\"f9701\":\"010102,01050304,011002,020101,020102,020105,020108,020207,020408,020501,020503,020601,020702,020705,020706,02070602,020707,020710,020714,02110101,02110102,021120,021213,021308,021404,021405,021408,021411,021701,021703,022406,0225,05011701\",\"f9943\":\"1199,8766,6047,3692,1213,647,9037,5083,7607,1473,1583,1254,7856,1220,10101,7866,8852,4222,7606,7860,3902,3895,1182,3976,2090,7742,7129,7413,7592,7751,1632,5211,2871,1525,2187\",\"f9702\":\"7\",\"f9944\":\"2424,1199,9901,8766,6047,3861,3692,1213,647,9037,537,5083,7607,2952,1473,1583,1254,7856,1220,10101,8916,9522,7866,8852,4222,3860,7606,7860,3902,3895,1182,3976,2090,7742,7129,7413,7592,7751,1632,5211,2871,1525,2187,7745\",\"f205002\":\"1358\",\"f205001\":\"1352\",\"f701001\":\"1063824\",\"f404003\":\"workother\",\"f106001\":\"12796\",\"f471004\":\"138,9,30,159,101,225,81,53,249,201,177\",\"f471003\":\"123,7,33,148,100,224,80,54,248,200,176\",\"f701002\":\"1069640\",\"f9607\":\"null,8766_20\",\"f9608\":\"null\",\"f426004\":\"0\",\"f9609\":\"null\",\"f503001\":\"4201\",\"time\":\"20200701021739\",\"f9601\":\"null,010102_20,01050304_20,011002_20,020101_20,020102_20,020105_20,020108_20,020207_20,020408_20,020501_20,020503_20,020601_20,020702_20,020705_20,020706_20,02070602_20,020707_20,020710_20,020714_20,02110101_20,02110102_20,021120_20,021213_20,021308_20,021404_20,021405_20,021408_20,021411_20,021701_20,021703_20,022406_20,0225_20,05011701_20\",\"f9602\":\"null,010102_07.19.0013,01050304_07.19.0013,011002_07.19.0013,020101_07.19.0013,020102_07.19.0013,020105_07.19.0013,020108_07.19.0013,020207_07.19.0013,020408_07.19.0013,020501_07.19.0013,020503_07.19.0013,020601_07.19.0013,020702_07.19.0013,020705_07.19.0013,020706_07.19.0013,02070602_07.19.0013,020707_07.19.0013,020710_07.19.0013,020714_07.19.0013,02110101_07.19.0013,02110102_07.19.0013,021120_07.19.0013,021213_07.19.0013,021308_07.19.0013,021404_07.19.0013,021405_07.19.0013,021408_07.19.0013,021411_07.19.0013,021701_07.19.0013,021703_07.19.0013,022406_07.19.0013,0225_07.19.0013,05011701_07.19.0013\",\"f415001\":\"133,182,32\",\"f9603\":\"null,010102_63824,01050304_63824,011002_63824,020101_63824,020102_63824,020105_63824,020108_63824,020207_63824,020408_63824,020501_63824,020503_63824,020601_63824,020702_63824,020705_63824,020706_63824,02070602_63824,020707_63824,020710_63824,020714_63824,02110101_63824,02110102_63824,021120_63824,021213_63824,021308_63824,021404_63824,021405_63824,021408_63824,021411_63824,021701_63824,021703_63824,022406_63824,0225_63824,05011701_63824\",\"f411001\":\"8\",\"f411003\":\"3\",\"f411002\":\"7\",\"f411005\":\"2\",\"f411004\":\"2\",\"f508002\":\"V1932A\",\"f806001\":\"6\",\"f508001\":\"\",\"f9914\":\"\",\"f806002\":\"15\",\"f9915\":\"\",\"f806003\":\"5\",\"f830101\":\"null,60193_63824,63956_63824\",\"f9916\":\"02.24.0001&11,02.24.0002&9,02.01.0002&9,02.01.0003&10,02.22.0001&10,02.22.0003&9,02.22.0006&9,02.17&9,02.05&9,02.10&9,02.19&9,02.15&11,02.03&11,02.09&10\",\"f806004\":\"8\",\"f830102\":\"null,8220_12796,19941_12796\",\"f9917\":\"02.24.0001&1,02.24.0002&1,02.01.0002&1,02.01.0003&1,02.22.0001&1,02.22.0003&1,02.22.0006&1,02.17&1,02.05&1,02.10&1,02.19&1,02.15&1,02.03&7,02.09&1\",\"f830103\":\"null,07.05.0001_07.19.0013\",\"f9918\":\"02.24.0001&1,02.24.0002&1,02.01.0002&1,02.01.0003&1,02.22.0001&1,02.22.0003&1,02.22.0006&1,02.17&1,02.05&1,02.10&1,02.19&1,02.15&1,02.03&1,02.09&1\",\"f830104\":\"null,17_20,6_20\",\"f9919\":\"02.24.0001&3,02.24.0002&5,02.01.0002&5,02.01.0003&4,02.22.0001&4,02.22.0003&5,02.22.0006&5,02.17&5,02.05&5,02.10&5,02.19&5,02.15&3,02.03&3,02.09&4\",\"f611001\":\"5\",\"f9902\":\"2424,1199,9901,8766,6047,3861,3692,1213,647,9037,8695,537,5083,7607,2952,1473,1583,8662,14861,1254,7856,7795,1220,10101,8916,9522,7866,8852,4222,1742,8450,5305,3860,1823,7606,7606,7860,2864,3902,3895,11072,1182,3976,2090,648,216,667,7742,4799,7129,8397,3451,7413,7413,239,7134,7592,7751,1632,5211,14676,2871,1525,2187,7745\",\"f9903\":\"18\",\"f9906\":\"\",\"f434009\":\"0\",\"f9907\":\"\",\"f9908\":\"0\",\"f434007\":\"0\",\"f434008\":\"0\",\"f434005\":\"0\",\"f434006\":\"0\",\"f434003\":\"0\",\"f434004\":\"0\",\"f434001\":\"0\",\"f434002\":\"0\",\"f141016\":\"0\",\"f141018\":\"0\",\"f9935\":\"8766\",\"f9936\":\"1199,8766,6047,3692,1213,647,9037,5083,7607,1473,1583,1254,7856,1220,10101,7866,8852,4222,7606,7860,3902,3895,1182,3976,2090,7742,7129,7413,7592,7751,1632,5211,2187\",\"f830001\":\"60193,63956\",\"f9937\":\"8695,8662,14861,8450,5305,2864,11072,216,4799,3451,239,7134,14676\",\"f830002\":\"8220,19941\",\"f830003\":\"07.05.0001\",\"f433008\":\"0\",\"f830004\":\"17,6\",\"f433006\":\"0\",\"f433007\":\"0\",\"f433004\":\"0\",\"f433005\":\"0\",\"f433002\":\"0\",\"f9930\":\"8\",\"f433003\":\"0\",\"f9931\":\"-1\",\"f9932\":\"-1\",\"f433001\":\"0\",\"f9933\":\"-1\",\"f9934\":\"-1\",\"f108001\":\"344551\",\"f807002\":\"12\",\"f9924\":\"02.01.0003,02.22.0006,02.24.0001,02.05,02.15,02.19,02.10,02.03\",\"f807001\":\"8\",\"f507001\":\"3\",\"f807004\":\"7\",\"f830111\":\"null\",\"f807003\":\"6\",\"f830112\":\"null\",\"f9927\":\"0\",\"f830113\":\"null\",\"f9928\":\"0\",\"f830114\":\"null\",\"f9929\":\"6\",\"f9921\":\"\",\"f9922\":\"\",\"f9923\":\"02.22.0001,02.01.0002,02.22.0003,02.24.0002,02.17,02.09\",\"f9802\":\"0\",\"f226007\":\"1\",\"f226006\":\"1\",\"f226005\":\"1\",\"f226004\":\"0\",\"f226003\":\"0\",\"f226002\":\"10\",\"f226001\":\"10\",\"f610001\":\"0\",\"f143010\":\"0\",\"f226008\":\"1\",\"f830011\":\"{0=, 2=, 3=}\",\"f830012\":\"{0=, 2=, 3=}\",\"f830013\":\"{0=, 2=, 3=}\",\"f830014\":\"{0=, 2=, 3=}\",\"f424004\":\"0\",\"f424006\":\"0\",\"f808002\":\"02.22.0001_0,02.01.0002_0,02.01.0003_0,02.22.0003_0,02.24.0002_0,02.22.0006_0,02.17_0,02.24.0001_0,02.05_0,02.15_0,02.09_0,02.19_0,02.10_0,0_1,02.03_1\",\"f423004\":\"0\",\"f506001\":\"2\",\"f434018\":\"0\",\"f423006\":\"0\",\"f434016\":\"0\",\"f121003\":\"null\",\"f434017\":\"0\",\"f8807\":\"1\",\"f434014\":\"0\",\"f434015\":\"0\",\"f434012\":\"0\",\"f434013\":\"0\",\"f808001\":\"02.22.0001_1,02.01.0002_1,02.01.0003_1,02.22.0003_1,02.24.0002_1,02.22.0006_1,02.17_1,02.24.0001_1,02.05_1,02.15_1,02.09_1,02.19_1,02.10_1,0_1,02.03_2\",\"f8803\":\"1\",\"f434010\":\"0\",\"f434011\":\"0\",\"f143007\":\"0\",\"f225006\":\"0\",\"f143006\":\"0\",\"f225005\":\"0\",\"f143009\":\"0\",\"f412002\":\"8\",\"f225004\":\"1\",\"f143008\":\"0\",\"f412001\":\"8\",\"f225003\":\"1\",\"f143003\":\"0\",\"f412004\":\"3\",\"f225002\":\"1\",\"f143002\":\"0\",\"f412003\":\"3\",\"f143005\":\"0\",\"f412006\":\"0\",\"f143004\":\"0\",\"f412005\":\"2\",\"f143001\":\"0\",\"f214001\":\"316,225,186,117,555,255,422,99,475,76\",\"f214002\":\"2325,508,1130,262,2489,4120,1934,4952,744,1088,4487,993,458,2100,4373,164,1203,3585,3131,3245,3664,226,3432,2596,1170,762,4304,4791,835,5491,603\",\"f214003\":\"315,226,187,117,555,255,421,99,476,79\",\"f214004\":\"2325,508,1129,259,2489,1935,4952,744,1089,4487,992,2100,165,3585,3131,226,2596,1170,835,5490,602\"}";
            JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
            HashMap<String, FeatureMapDo> featureMap = new HashMap<String, FeatureMapDo>();
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap((Map)featureIdxMap);
            featureMap.put("Q", featureMapDo);
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
            map.put("a", featureIdxMap);
            DCVR dcvr = new DCVR((IModel)coderModel);
            dcvr.setDcvrServingClient(tfServingClient);
            for (int i = 0; i < 100; ++i) {
                System.out.println(coderModel.getUpdateTime());
                System.out.println(JSON.toJSONString((Object)dcvr.predictDCvrWithTF(featureMap)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void test3(ESMM model) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(30);
        for (int i = 0; i < 4; ++i) {
            RunnableThread thread = new RunnableThread(model);
            Thread.sleep(10L);
            executorService.execute(thread);
        }
        executorService.shutdown();
    }

    public static void testESMM(ESMM model) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"38944\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        HashMap<Long, Long> retMap = new HashMap<Long, Long>();
        int times = 1000;
        System.out.println("start " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long tStart = System.currentTimeMillis();
        for (int j = 0; j < times; ++j) {
            HashMap<String, JSONObject> req = new HashMap<String, JSONObject>();
            for (int i = 0; i < 100; ++i) {
                req.put("a" + i, featureIdxMap);
            }
            long tStart_2 = System.currentTimeMillis();
            Map ret1 = model.predictCTRsAndCVRsWithTF(req);
            long tEnd_2 = System.currentTimeMillis();
            Long diff_2 = tEnd_2 - tStart_2;
            retMap.put(diff_2, retMap.getOrDefault(diff_2, 0L) + 1L);
        }
        long tEnd = System.currentTimeMillis();
        System.out.println("end " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("diff=" + (tEnd - tStart) / (long)times);
        System.out.println("retMap=" + JSON.toJSONString(retMap));
    }

    public static void test(IModel m) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"20976\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        TFServingClient tfServingClient = new TFServingClient("10.50.201.72", 9000, "dcn-ctr-002", null);
        HashMap<String, JSONObject> req = new HashMap<String, JSONObject>();
        for (int i = 0; i < 100; ++i) {
            featureIdxMap.put("f108001", "" + i);
            req.put("a" + i, featureIdxMap);
        }
        Map ret = m.predictWithTF(req, null);
        System.out.println("ret=" + JSON.toJSONString((Object)ret));
    }

    public static void test2(FM m) throws Exception {
        String featureStr = "{\"f604001\":\"1\",\"f501001\":\"Android\",\"f608001\":\"1\",\"f113001\":\"40104,04.01.0001\",\"f610001\":\"0\",\"f9913\":\"20\",\"f508002\":\"A59s\",\"f806001\":\"15\",\"f508001\":\"OPPO\",\"f9914\":\"com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.documentsui,com.android.dreams.basic,com.android.externalstorage,com.android.htmlviewer,com.android.inputdevices,com.android.keychain,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.redteamobile.virtual.softsim,com.rzwifi.password,com.svox.pico,com.tencent.mm,org.simalliance.openmobileapi.service,se.dirac.acs\",\"f806002\":\"12\",\"f9915\":\"\\\\N,28,1,62,5,19,23,17,60,37,65,40,4,47,21,68,52\",\"f206001\":\"262\",\"f104001\":\"null\",\"f504001\":\"OPPO A59s\",\"f601001\":\"2\",\"f303001\":\"6\",\"f9912\":\"2063\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"11\",\"f502002\":\"4\",\"f611001\":\"2\",\"f206002\":\"260\",\"f403004\":\"0\",\"f9902\":\"android,com.amap.android.location,com.android.bluetooth,com.android.browser,com.android.calculator2,com.android.calendar,com.android.captiveportallogin,com.android.certinstaller,com.android.contacts,com.android.defcontainer,com.android.dlna.service,com.android.documentsui,com.android.dreams.basic,com.android.dreams.phototable,com.android.externalstorage,com.android.htmlviewer,com.android.incallui,com.android.inputdevices,com.android.keychain,com.android.keyguard,com.android.location.fused,com.android.managedprovisioning,com.android.mms,com.android.mms.service,com.android.onetimeinitializer,com.android.packageinstaller,com.android.pacprocessor,com.android.phone,com.android.printspooler,com.android.providers.applications,com.android.providers.calendar,com.android.providers.contacts,com.android.providers.downloads,com.android.providers.media,com.android.providers.settings,com.android.providers.telephony,com.android.providers.userdictionary,com.android.proxyhandler,com.android.server.telecom,com.android.settings,com.android.sharedstoragebackup,com.android.shell,com.android.stk,com.android.systemui,com.android.utk,com.android.vendors.bridge.softsim,com.android.vpndialogs,com.android.wallpaper.livepicker,com.android.wallpapercropper,com.cgshi.fruit1,com.cleanmaster.sdk,com.color.uiengine,com.coloros.activation,com.coloros.alarmclock,com.coloros.appmanager,com.coloros.backup.composer.app,com.coloros.backuprestore,com.coloros.backuprestore.remoteservice,com.coloros.blacklist,com.coloros.bootreg,com.coloros.cloud,com.coloros.compass,com.coloros.exserviceui,com.coloros.feedback,com.coloros.filemanager,com.coloros.findmyphone,com.coloros.fingerprint,com.coloros.flashlight,com.coloros.gallery3d,com.coloros.gesture,com.coloros.keyguard.notification,com.coloros.leather,com.coloros.mcs,com.coloros.newsimdetect,com.coloros.notificationmanager,com.coloros.operationmanual,com.coloros.oppoguardelf,com.coloros.oppomorningsystem,com.coloros.oppomultiapp,com.coloros.phonenoareainquire,com.coloros.photoeffects,com.coloros.pictorial,com.coloros.preventmode,com.coloros.providers.downloads.ui,com.coloros.recents,com.coloros.safe.service.framework,com.coloros.safecenter,com.coloros.sau,com.coloros.screenshot,com.coloros.simsettings,com.coloros.soundrecorder,com.coloros.speechassist,com.coloros.speechassist.engine,com.coloros.usbselection,com.coloros.video,com.coloros.wallpapers,com.coloros.weather,com.coloros.weather.service,com.coloros.widget.smallweather,com.coloros.wirelesssettings,com.criticallog,com.dropboxchmod,com.gnss.power,com.google.android.webview,com.hdkino.browser,com.iflytek.speechcloud,com.mediatek,com.mediatek.atci.service,com.mediatek.connectivity,com.mediatek.engineermode,com.mediatek.fwk.plugin,com.mediatek.gba,com.mediatek.hetcomm,com.mediatek.lbs.em2.ui,com.mediatek.miravision.ui,com.mediatek.mtklogger,com.mediatek.nlpservice,com.mediatek.providers.drm,com.mediatek.ygps,com.mobiletools.systemhelper,com.nearme.atlas,com.nearme.gamecenter,com.nearme.romupdate,com.nearme.statistics.rom,com.nearme.sync,com.nearme.themespace,com.nearme.themespacelib,com.oppo.autotest,com.oppo.bluetooth.pbapclient,com.oppo.c2u,com.oppo.camera,com.oppo.camera.doubleexposure,com.oppo.camera.facebeauty,com.oppo.camera.fastvideomode,com.oppo.camera.filter,com.oppo.camera.gif,com.oppo.camera.panorama,com.oppo.camera.professional,com.oppo.camera.superzoom,com.oppo.ctautoregist,com.oppo.dirac,com.oppo.engineeringmode.specialtest,com.oppo.engineermode,com.oppo.factorygps,com.oppo.fingerprints.fingerprintsensortest,com.oppo.fingerprints.service,com.oppo.gestureservice,com.oppo.launcher,com.oppo.market,com.oppo.music,com.oppo.ota,com.oppo.quicksearchbox,com.oppo.reader,com.oppo.resmonitor,com.oppo.sdcardservice,com.oppo.usagedump,com.oppo.usercenter,com.oppo.webview,com.redteamobile.roaming,com.redteamobile.virtual.softsim,com.rzwifi.password,com.sohu.inputmethod.sogouoem,com.svox.pico,com.ted.number,com.tencent.mm,com.ziipin.softkeyboard,com.zy.org.megabucks.by,oppo,org.simalliance.openmobileapi.eseterminal,org.simalliance.openmobileapi.service,org.simalliance.openmobileapi.uicc1terminal,org.simalliance.openmobileapi.uicc2terminal,se.dirac.acs\",\"f805001\":\"14\",\"f805002\":\"12\",\"f505001\":\"1700-2699\",\"f9906\":\"10,\\\\N,22,32,16,31\",\"f9907\":\"1004,\\\\N,2208,3205,1601,2203,2202,3106\",\"f9908\":\"1\",\"f602001\":\"2\",\"f606001\":\"-1\",\"f205002\":\"55\",\"f205001\":\"27\",\"f201001\":\"21054\",\"f102001\":\"20806,02.15.0008\",\"f106001\":\"5102\",\"f609001\":\"0\",\"f804002\":\"12\",\"f804001\":\"14\",\"f301001\":\"1579\",\"f605001\":\"1\",\"f108001\":\"3408\",\"f807002\":\"12\",\"f101001\":\"20976\",\"f807001\":\"14\",\"f507001\":\"3\",\"f503001\":\"6532\",\"f302001\":\"1579\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        featureIdxMap.put("sub_net_id", "10.0");
        double[] ret = m.getParam2((Map)featureIdxMap);
        System.out.println("ret=" + JSON.toJSONString((Object)ret));
    }

    public static void test1(IModel m) throws Exception {
        String featureStr = "{\"f602001\":\"1\",\"f604001\":\"1\",\"f606001\":\"-1\",\"f501001\":\"Android\",\"f608001\":\"0\",\"f113001\":\"40103\",\"f610001\":\"0\",\"cf101201\":\"1565836007\",\"cf101301\":\"156583558\",\"f201001\":\"36007\",\"f102001\":\"22001\",\"f106001\":\"291\",\"f506001\":\"1\",\"f104001\":\"null\",\"f504001\":\"HUAWEINXT-DL00\",\"f609001\":\"0\",\"f601001\":\"1\",\"f301001\":\"3558\",\"f303001\":\"2\",\"f605001\":\"-1\",\"f603001\":\"1\",\"f110001\":\"1\",\"f607001\":\"0\",\"f502001\":\"8\",\"f108001\":\"3964\",\"f502002\":\"0\",\"f611001\":\"1\",\"f403004\":\"0\",\"f101001\":\"15658\",\"f505001\":\"1700-2699\",\"f503001\":\"31\",\"f302001\":\"3558\",\"f306001\":\"2\"}";
        JSONObject featureIdxMap = JSON.parseObject((String)featureStr);
        TFServingClient tfServingClient = new TFServingClient("10.50.201.72", 9000, "dcn-ctr-002", null);
        int times = 100;
        System.out.println("start " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long tStart = System.currentTimeMillis();
        for (int j = 0; j < times; ++j) {
            HashMap<String, JSONObject> req2 = new HashMap<String, JSONObject>();
            for (int i = 0; i < 100; ++i) {
                req2.put("a" + i, featureIdxMap);
            }
            Map retTmp = m.predictWithTF(req2, tfServingClient);
            System.out.println(j);
        }
        long tEnd = System.currentTimeMillis();
        System.out.println("end " + DateUtil.getCurrentTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("diff=" + (tEnd - tStart) / (long)times);
    }

    static class RunnableThread
    implements Runnable {
        private ESMM model;

        RunnableThread(ESMM model) {
            this.model = model;
        }

        @Override
        public void run() {
            try {
                CoderReadTest.testESMM(this.model);
                System.out.println("\u901a\u8fc7\u7ebf\u7a0b\u6c60\u65b9\u5f0f\u521b\u5efa\u7684\u7ebf\u7a0b\uff1a" + Thread.currentThread().getName() + " ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

