package cn.com.duiba.nezha.alg.example.example;

import cn.com.duiba.nezha.alg.example.util.FileUtil;
import cn.com.duiba.nezha.alg.example.util.JedisUtil;
import cn.com.duiba.nezha.alg.example.util.StdCoderModelSaveBo;
import cn.com.duiba.nezha.alg.example.util.StdModelSave;
import cn.com.duiba.nezha.alg.example.util.conf.JedisConfig;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.FM;
import com.alibaba.fastjson.JSON;
import org.junit.Test;

public class LoadModelToTest {

    public static void main(String[] args) {

        on2file();
//        file2off();
        //get();
//        on2on();
    }

    public static void on2file() {

//        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("mid_ftrl_coder_dcvr_v101");

        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("deep_fm_e2e_dpa_cost_v004", "dpa");
//        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_resplug_coder_dqn_v001");
        System.out.println(coderModel.getUpdateTime());
        System.out.println(JSON.toJSONString(coderModel.getFeatureBaseType()));
        String content = JSON.toJSONString(coderModel);
        FileUtil.write(content, "/Users/lwj/Desktop/model101");
    }


    public static void file2off() {
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);
        String file = FileUtil.read("/Users/lwj/Desktop/model101");

        CODER coderModel = JSON.parseObject(file, CODER.class);
        System.out.println(coderModel.getUpdateTime());

        StdCoderModelSaveBo.saveModelCoderByKeyToJedis("mid_ftrl_coder_dcvr_v101", coderModel, juOffline);

    }


    public static void off2off() {
        JedisConfig jcOffline = new JedisConfig();

        jcOffline.setIp("test.config.dui88.com");
        jcOffline.setPassWord("duiba123");
        jcOffline.setPort(6379);
        JedisUtil juOffline = new JedisUtil(jcOffline);
        String file = FileUtil.read("/Users/lwj/Desktop/model1");

        CODER coderModel = JSON.parseObject(file, CODER.class);

        System.out.println(coderModel.getUpdateTime());

        StdCoderModelSaveBo.saveModelCoderByKeyToJedis("act_title_coder_dqn_v001", coderModel, juOffline);

    }


    public static void on2on() {


        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_intercept_coder_dqn_v001", "act");
        System.out.println(coderModel.getUpdateTime());
        StdCoderModelSaveBo.saveModelCoderByKeyToJedis("plug_intercept_coder_dqn_v001", coderModel, "act");

    }

    public static void get() {
//
//
//        CODER coderModel = StdCoderModelSaveBo.getModelCoderByKeyFromJedis("act_title_prize_coder_dqn_v001", "act");
//
//        System.out.println(coderModel.getUpdateTime());

        String key2 = "mid_ftrl_fm_bcvr_v009";
        FM modelCtr = StdModelSave.getModelByKeyFromJedis(key2);
        System.out.println(modelCtr.getUpdateTime());
    }
}
